// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType
import aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement
import aws.sdk.kotlin.services.sagemaker.model.AuthMode
import aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse
import aws.sdk.kotlin.services.sagemaker.model.DomainSettings
import aws.sdk.kotlin.services.sagemaker.model.DomainStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDomainOperationDeserializer: HttpDeserialize<DescribeDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDomainResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDomainError(context, response)
        }
        val builder = DescribeDomainResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDomainOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDomainError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDomainOperationBody(builder: DescribeDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPNETWORKACCESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppNetworkAccessType"))
    val APPSECURITYGROUPMANAGEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppSecurityGroupManagement"))
    val AUTHMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthMode"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEFAULTUSERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultUserSettings"))
    val DOMAINARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainArn"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val DOMAINSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DomainSettings"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HOMEEFSFILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HomeEfsFileSystemId"))
    val HOMEEFSFILESYSTEMKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HomeEfsFileSystemKmsKeyId"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val SECURITYGROUPIDFORDOMAINBOUNDARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecurityGroupIdForDomainBoundary"))
    val SINGLESIGNONMANAGEDAPPLICATIONINSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SingleSignOnManagedApplicationInstanceId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetIds"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Url"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPNETWORKACCESSTYPE_DESCRIPTOR)
        field(APPSECURITYGROUPMANAGEMENT_DESCRIPTOR)
        field(AUTHMODE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DEFAULTUSERSETTINGS_DESCRIPTOR)
        field(DOMAINARN_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINSETTINGS_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HOMEEFSFILESYSTEMID_DESCRIPTOR)
        field(HOMEEFSFILESYSTEMKMSKEYID_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(SECURITYGROUPIDFORDOMAINBOUNDARY_DESCRIPTOR)
        field(SINGLESIGNONMANAGEDAPPLICATIONINSTANCEID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(URL_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPNETWORKACCESSTYPE_DESCRIPTOR.index -> builder.appNetworkAccessType = deserializeString().let { AppNetworkAccessType.fromValue(it) }
                APPSECURITYGROUPMANAGEMENT_DESCRIPTOR.index -> builder.appSecurityGroupManagement = deserializeString().let { AppSecurityGroupManagement.fromValue(it) }
                AUTHMODE_DESCRIPTOR.index -> builder.authMode = deserializeString().let { AuthMode.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTUSERSETTINGS_DESCRIPTOR.index -> builder.defaultUserSettings = deserializeUserSettingsDocument(deserializer)
                DOMAINARN_DESCRIPTOR.index -> builder.domainArn = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                DOMAINSETTINGS_DESCRIPTOR.index -> builder.domainSettings = deserializeDomainSettingsDocument(deserializer)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HOMEEFSFILESYSTEMID_DESCRIPTOR.index -> builder.homeEfsFileSystemId = deserializeString()
                HOMEEFSFILESYSTEMKMSKEYID_DESCRIPTOR.index -> builder.homeEfsFileSystemKmsKeyId = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SECURITYGROUPIDFORDOMAINBOUNDARY_DESCRIPTOR.index -> builder.securityGroupIdForDomainBoundary = deserializeString()
                SINGLESIGNONMANAGEDAPPLICATIONINSTANCEID_DESCRIPTOR.index -> builder.singleSignOnManagedApplicationInstanceId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DomainStatus.fromValue(it) }
                SUBNETIDS_DESCRIPTOR.index -> builder.subnetIds =
                    deserializer.deserializeList(SUBNETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
