// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeHyperParameterTuningJobResponse
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStatus
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig
import aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeHyperParameterTuningJobOperationDeserializer: HttpDeserialize<DescribeHyperParameterTuningJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeHyperParameterTuningJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeHyperParameterTuningJobError(context, response)
        }
        val builder = DescribeHyperParameterTuningJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHyperParameterTuningJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeHyperParameterTuningJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHyperParameterTuningJobOperationBody(builder: DescribeHyperParameterTuningJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BESTTRAININGJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BestTrainingJob"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HYPERPARAMETERTUNINGENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("HyperParameterTuningEndTime"))
    val HYPERPARAMETERTUNINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HyperParameterTuningJobArn"))
    val HYPERPARAMETERTUNINGJOBCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HyperParameterTuningJobConfig"))
    val HYPERPARAMETERTUNINGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HyperParameterTuningJobName"))
    val HYPERPARAMETERTUNINGJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HyperParameterTuningJobStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val OBJECTIVESTATUSCOUNTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ObjectiveStatusCounters"))
    val OVERALLBESTTRAININGJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverallBestTrainingJob"))
    val TRAININGJOBDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingJobDefinition"))
    val TRAININGJOBDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TrainingJobDefinitions"))
    val TRAININGJOBSTATUSCOUNTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingJobStatusCounters"))
    val WARMSTARTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WarmStartConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BESTTRAININGJOB_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGENDTIME_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBARN_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBCONFIG_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBNAME_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(OBJECTIVESTATUSCOUNTERS_DESCRIPTOR)
        field(OVERALLBESTTRAININGJOB_DESCRIPTOR)
        field(TRAININGJOBDEFINITION_DESCRIPTOR)
        field(TRAININGJOBDEFINITIONS_DESCRIPTOR)
        field(TRAININGJOBSTATUSCOUNTERS_DESCRIPTOR)
        field(WARMSTARTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BESTTRAININGJOB_DESCRIPTOR.index -> builder.bestTrainingJob = deserializeHyperParameterTrainingJobSummaryDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HYPERPARAMETERTUNINGENDTIME_DESCRIPTOR.index -> builder.hyperParameterTuningEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                HYPERPARAMETERTUNINGJOBARN_DESCRIPTOR.index -> builder.hyperParameterTuningJobArn = deserializeString()
                HYPERPARAMETERTUNINGJOBCONFIG_DESCRIPTOR.index -> builder.hyperParameterTuningJobConfig = deserializeHyperParameterTuningJobConfigDocument(deserializer)
                HYPERPARAMETERTUNINGJOBNAME_DESCRIPTOR.index -> builder.hyperParameterTuningJobName = deserializeString()
                HYPERPARAMETERTUNINGJOBSTATUS_DESCRIPTOR.index -> builder.hyperParameterTuningJobStatus = deserializeString().let { HyperParameterTuningJobStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                OBJECTIVESTATUSCOUNTERS_DESCRIPTOR.index -> builder.objectiveStatusCounters = deserializeObjectiveStatusCountersDocument(deserializer)
                OVERALLBESTTRAININGJOB_DESCRIPTOR.index -> builder.overallBestTrainingJob = deserializeHyperParameterTrainingJobSummaryDocument(deserializer)
                TRAININGJOBDEFINITION_DESCRIPTOR.index -> builder.trainingJobDefinition = deserializeHyperParameterTrainingJobDefinitionDocument(deserializer)
                TRAININGJOBDEFINITIONS_DESCRIPTOR.index -> builder.trainingJobDefinitions =
                    deserializer.deserializeList(TRAININGJOBDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<HyperParameterTrainingJobDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHyperParameterTrainingJobDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRAININGJOBSTATUSCOUNTERS_DESCRIPTOR.index -> builder.trainingJobStatusCounters = deserializeTrainingJobStatusCountersDocument(deserializer)
                WARMSTARTCONFIG_DESCRIPTOR.index -> builder.warmStartConfig = deserializeHyperParameterTuningJobWarmStartConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
