// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageResponse
import aws.sdk.kotlin.services.sagemaker.model.ImageStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeImageOperationDeserializer: HttpDeserialize<DescribeImageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeImageResponse {
        if (!response.status.isSuccess()) {
            throwDescribeImageError(context, response)
        }
        val builder = DescribeImageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeImageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeImageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImageOperationBody(builder: DescribeImageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val IMAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageArn"))
    val IMAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageName"))
    val IMAGESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(IMAGEARN_DESCRIPTOR)
        field(IMAGENAME_DESCRIPTOR)
        field(IMAGESTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                IMAGEARN_DESCRIPTOR.index -> builder.imageArn = deserializeString()
                IMAGENAME_DESCRIPTOR.index -> builder.imageName = deserializeString()
                IMAGESTATUS_DESCRIPTOR.index -> builder.imageStatus = deserializeString().let { ImageStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
