// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A channel is a named input source that training algorithms can consume. The validation dataset size is limited to less than 2 GB. The training dataset size must be less than 100 GB. For more information, see .
 *
 * A validation dataset must contain the same headers as the training dataset.
 */
public class AutoMlChannel private constructor(builder: Builder) {
    /**
     * The channel type (optional) is an `enum` string. The default value is `training`. Channels for training and validation must share the same `ContentType` and `TargetAttributeName`. For information on specifying training and validation channel types, see `How to specify training and validation datasets`[](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-data-sources-training-or-validation).
     */
    public val channelType: aws.sdk.kotlin.services.sagemaker.model.AutoMlChannelType? = builder.channelType
    /**
     * You can use `Gzip` or `None`. The default value is `None`.
     */
    public val compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = builder.compressionType
    /**
     * The content type of the data from the input source. You can use `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The data source for an AutoML channel.
     */
    public val dataSource: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource? = builder.dataSource
    /**
     * The name of the target variable in supervised learning, usually represented by 'y'.
     */
    public val targetAttributeName: kotlin.String? = builder.targetAttributeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlChannel(")
        append("channelType=$channelType,")
        append("compressionType=$compressionType,")
        append("contentType=$contentType,")
        append("dataSource=$dataSource,")
        append("targetAttributeName=$targetAttributeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelType?.hashCode() ?: 0
        result = 31 * result + (compressionType?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (targetAttributeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlChannel

        if (channelType != other.channelType) return false
        if (compressionType != other.compressionType) return false
        if (contentType != other.contentType) return false
        if (dataSource != other.dataSource) return false
        if (targetAttributeName != other.targetAttributeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlChannel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The channel type (optional) is an `enum` string. The default value is `training`. Channels for training and validation must share the same `ContentType` and `TargetAttributeName`. For information on specifying training and validation channel types, see `How to specify training and validation datasets`[](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-data-sources-training-or-validation).
         */
        public var channelType: aws.sdk.kotlin.services.sagemaker.model.AutoMlChannelType? = null
        /**
         * You can use `Gzip` or `None`. The default value is `None`.
         */
        public var compressionType: aws.sdk.kotlin.services.sagemaker.model.CompressionType? = null
        /**
         * The content type of the data from the input source. You can use `text/csv;header=present` or `x-application/vnd.amazon+parquet`. The default value is `text/csv;header=present`.
         */
        public var contentType: kotlin.String? = null
        /**
         * The data source for an AutoML channel.
         */
        public var dataSource: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource? = null
        /**
         * The name of the target variable in supervised learning, usually represented by 'y'.
         */
        public var targetAttributeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlChannel) : this() {
            this.channelType = x.channelType
            this.compressionType = x.compressionType
            this.contentType = x.contentType
            this.dataSource = x.dataSource
            this.targetAttributeName = x.targetAttributeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlChannel = AutoMlChannel(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSource.invoke(block)
        }
    }
}
