// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A parameter used to configure the SageMaker Clarify explainer to treat text features as text so that explanations are provided for individual units of text. Required only for natural language processing (NLP) explainability.
 */
public class ClarifyTextConfig private constructor(builder: Builder) {
    /**
     * The unit of granularity for the analysis of text features. For example, if the unit is `'token'`, then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.
     */
    public val granularity: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextGranularity? = builder.granularity
    /**
     * Specifies the language of the text features in [ISO 639-1]( https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) or [ISO 639-3](https://en.wikipedia.org/wiki/ISO_639-3) code of a supported language.
     *
     * For a mix of multiple languages, use code `'xx'`.
     */
    public val language: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextLanguage? = builder.language

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClarifyTextConfig(")
        append("granularity=$granularity,")
        append("language=$language")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = granularity?.hashCode() ?: 0
        result = 31 * result + (language?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClarifyTextConfig

        if (granularity != other.granularity) return false
        if (language != other.language) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unit of granularity for the analysis of text features. For example, if the unit is `'token'`, then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.
         */
        public var granularity: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextGranularity? = null
        /**
         * Specifies the language of the text features in [ISO 639-1]( https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) or [ISO 639-3](https://en.wikipedia.org/wiki/ISO_639-3) code of a supported language.
         *
         * For a mix of multiple languages, use code `'xx'`.
         */
        public var language: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextLanguage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig) : this() {
            this.granularity = x.granularity
            this.language = x.language
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig = ClarifyTextConfig(this)
    }
}
