// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateDomainRequest private constructor(builder: Builder) {
    /**
     * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`.
     * + `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access
     * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets
     */
    public val appNetworkAccessType: aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType? = builder.appNetworkAccessType
    /**
     * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Required when `CreateDomain.AppNetworkAccessType` is `VPCOnly` and `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn` is provided.
     */
    public val appSecurityGroupManagement: aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement? = builder.appSecurityGroupManagement
    /**
     * The mode of authentication that members use to access the domain.
     */
    public val authMode: aws.sdk.kotlin.services.sagemaker.model.AuthMode? = builder.authMode
    /**
     * The default settings used to create a space.
     */
    public val defaultSpaceSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings? = builder.defaultSpaceSettings
    /**
     * The default settings to use to create a user profile when `UserSettings` isn't specified in the call to the `CreateUserProfile` API.
     *
     * `SecurityGroups` is aggregated when specified in both calls. For all other settings in `UserSettings`, the values specified in `CreateUserProfile` take precedence over those specified in `CreateDomain`.
     */
    public val defaultUserSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = builder.defaultUserSettings
    /**
     * A name for the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * A collection of `Domain` settings.
     */
    public val domainSettings: aws.sdk.kotlin.services.sagemaker.model.DomainSettings? = builder.domainSettings
    /**
     * Use `KmsKeyId`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val homeEfsFileSystemKmsKeyId: kotlin.String? = builder.homeEfsFileSystemKmsKeyId
    /**
     * SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, specify a customer managed key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The VPC subnets that Studio uses for communication.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the `Search` API.
     *
     * Tags that you specify for the Domain are also added to all Apps that the Domain launches.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainRequest(")
        append("appNetworkAccessType=$appNetworkAccessType,")
        append("appSecurityGroupManagement=$appSecurityGroupManagement,")
        append("authMode=$authMode,")
        append("defaultSpaceSettings=$defaultSpaceSettings,")
        append("defaultUserSettings=$defaultUserSettings,")
        append("domainName=$domainName,")
        append("domainSettings=$domainSettings,")
        append("homeEfsFileSystemKmsKeyId=$homeEfsFileSystemKmsKeyId,")
        append("kmsKeyId=$kmsKeyId,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appNetworkAccessType?.hashCode() ?: 0
        result = 31 * result + (appSecurityGroupManagement?.hashCode() ?: 0)
        result = 31 * result + (authMode?.hashCode() ?: 0)
        result = 31 * result + (defaultSpaceSettings?.hashCode() ?: 0)
        result = 31 * result + (defaultUserSettings?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainSettings?.hashCode() ?: 0)
        result = 31 * result + (homeEfsFileSystemKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDomainRequest

        if (appNetworkAccessType != other.appNetworkAccessType) return false
        if (appSecurityGroupManagement != other.appSecurityGroupManagement) return false
        if (authMode != other.authMode) return false
        if (defaultSpaceSettings != other.defaultSpaceSettings) return false
        if (defaultUserSettings != other.defaultUserSettings) return false
        if (domainName != other.domainName) return false
        if (domainSettings != other.domainSettings) return false
        if (homeEfsFileSystemKmsKeyId != other.homeEfsFileSystemKmsKeyId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateDomainRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`.
         * + `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access
         * + `VpcOnly` - All Studio traffic is through the specified VPC and subnets
         */
        public var appNetworkAccessType: aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType? = null
        /**
         * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Required when `CreateDomain.AppNetworkAccessType` is `VPCOnly` and `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn` is provided.
         */
        public var appSecurityGroupManagement: aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement? = null
        /**
         * The mode of authentication that members use to access the domain.
         */
        public var authMode: aws.sdk.kotlin.services.sagemaker.model.AuthMode? = null
        /**
         * The default settings used to create a space.
         */
        public var defaultSpaceSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings? = null
        /**
         * The default settings to use to create a user profile when `UserSettings` isn't specified in the call to the `CreateUserProfile` API.
         *
         * `SecurityGroups` is aggregated when specified in both calls. For all other settings in `UserSettings`, the values specified in `CreateUserProfile` take precedence over those specified in `CreateDomain`.
         */
        public var defaultUserSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = null
        /**
         * A name for the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * A collection of `Domain` settings.
         */
        public var domainSettings: aws.sdk.kotlin.services.sagemaker.model.DomainSettings? = null
        /**
         * Use `KmsKeyId`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var homeEfsFileSystemKmsKeyId: kotlin.String? = null
        /**
         * SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, specify a customer managed key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The VPC subnets that Studio uses for communication.
         */
        public var subnetIds: List<String>? = null
        /**
         * Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the `Search` API.
         *
         * Tags that you specify for the Domain are also added to all Apps that the Domain launches.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateDomainRequest) : this() {
            this.appNetworkAccessType = x.appNetworkAccessType
            this.appSecurityGroupManagement = x.appSecurityGroupManagement
            this.authMode = x.authMode
            this.defaultSpaceSettings = x.defaultSpaceSettings
            this.defaultUserSettings = x.defaultUserSettings
            this.domainName = x.domainName
            this.domainSettings = x.domainSettings
            this.homeEfsFileSystemKmsKeyId = x.homeEfsFileSystemKmsKeyId
            this.kmsKeyId = x.kmsKeyId
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateDomainRequest = CreateDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings] inside the given [block]
         */
        public fun defaultSpaceSettings(block: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings.Builder.() -> kotlin.Unit) {
            this.defaultSpaceSettings = aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserSettings] inside the given [block]
         */
        public fun defaultUserSettings(block: aws.sdk.kotlin.services.sagemaker.model.UserSettings.Builder.() -> kotlin.Unit) {
            this.defaultUserSettings = aws.sdk.kotlin.services.sagemaker.model.UserSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DomainSettings] inside the given [block]
         */
        public fun domainSettings(block: aws.sdk.kotlin.services.sagemaker.model.DomainSettings.Builder.() -> kotlin.Unit) {
            this.domainSettings = aws.sdk.kotlin.services.sagemaker.model.DomainSettings.invoke(block)
        }
    }
}
