// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateEndpointConfigRequest private constructor(builder: Builder) {
    /**
     * Specifies configuration for how an endpoint performs asynchronous inference. This is a required field in order for your Endpoint to be invoked using [InvokeEndpointAsync](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html).
     */
    public val asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = builder.asyncInferenceConfig
    /**
     * Configuration to control how SageMaker captures inference data.
     */
    public val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig? = builder.dataCaptureConfig
    /**
     * The name of the endpoint configuration. You specify this name in a CreateEndpoint request.
     */
    public val endpointConfigName: kotlin.String? = builder.endpointConfigName
    /**
     * A member of `CreateEndpointConfig` that enables explainers.
     */
    public val explainerConfig: aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig? = builder.explainerConfig
    /**
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     *
     * The KmsKeyId can be any of the following formats:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
     *
     * The KMS key policy must grant permission to the IAM role that you specify in your `CreateEndpoint`, `UpdateEndpoint` requests. For more information, refer to the Amazon Web Services Key Management Service section[ Using Key Policies in Amazon Web Services KMS ](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
     *
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a `KmsKeyId` when using an instance type with local storage. If any of the models that you specify in the `ProductionVariants` parameter use nitro-based instances with local storage, do not specify a value for the `KmsKeyId` parameter. If you specify a value for `KmsKeyId` when using any nitro-based instances with local storage, the call to `CreateEndpointConfig` fails.
     *
     * For a list of instance types that support local instance storage, see [Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
     *
     * For more information about local instance storage encryption, see [SSD Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
     */
    public val productionVariants: List<ProductionVariant>? = builder.productionVariants
    /**
     * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on `ProductionVariants`. If you use this field, you can only specify one variant for `ProductionVariants` and one variant for `ShadowProductionVariants`.
     */
    public val shadowProductionVariants: List<ProductionVariant>? = builder.shadowProductionVariants
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateEndpointConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEndpointConfigRequest(")
        append("asyncInferenceConfig=$asyncInferenceConfig,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("endpointConfigName=$endpointConfigName,")
        append("explainerConfig=$explainerConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("productionVariants=$productionVariants,")
        append("shadowProductionVariants=$shadowProductionVariants,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = asyncInferenceConfig?.hashCode() ?: 0
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigName?.hashCode() ?: 0)
        result = 31 * result + (explainerConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (productionVariants?.hashCode() ?: 0)
        result = 31 * result + (shadowProductionVariants?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEndpointConfigRequest

        if (asyncInferenceConfig != other.asyncInferenceConfig) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (endpointConfigName != other.endpointConfigName) return false
        if (explainerConfig != other.explainerConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (productionVariants != other.productionVariants) return false
        if (shadowProductionVariants != other.shadowProductionVariants) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateEndpointConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies configuration for how an endpoint performs asynchronous inference. This is a required field in order for your Endpoint to be invoked using [InvokeEndpointAsync](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html).
         */
        public var asyncInferenceConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig? = null
        /**
         * Configuration to control how SageMaker captures inference data.
         */
        public var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig? = null
        /**
         * The name of the endpoint configuration. You specify this name in a CreateEndpoint request.
         */
        public var endpointConfigName: kotlin.String? = null
        /**
         * A member of `CreateEndpointConfig` that enables explainers.
         */
        public var explainerConfig: aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig? = null
        /**
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         *
         * The KmsKeyId can be any of the following formats:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
         *
         * The KMS key policy must grant permission to the IAM role that you specify in your `CreateEndpoint`, `UpdateEndpoint` requests. For more information, refer to the Amazon Web Services Key Management Service section[ Using Key Policies in Amazon Web Services KMS ](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
         *
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a `KmsKeyId` when using an instance type with local storage. If any of the models that you specify in the `ProductionVariants` parameter use nitro-based instances with local storage, do not specify a value for the `KmsKeyId` parameter. If you specify a value for `KmsKeyId` when using any nitro-based instances with local storage, the call to `CreateEndpointConfig` fails.
         *
         * For a list of instance types that support local instance storage, see [Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
         *
         * For more information about local instance storage encryption, see [SSD Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint.
         */
        public var productionVariants: List<ProductionVariant>? = null
        /**
         * An array of `ProductionVariant` objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on `ProductionVariants`. If you use this field, you can only specify one variant for `ProductionVariants` and one variant for `ShadowProductionVariants`.
         */
        public var shadowProductionVariants: List<ProductionVariant>? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateEndpointConfigRequest) : this() {
            this.asyncInferenceConfig = x.asyncInferenceConfig
            this.dataCaptureConfig = x.dataCaptureConfig
            this.endpointConfigName = x.endpointConfigName
            this.explainerConfig = x.explainerConfig
            this.kmsKeyId = x.kmsKeyId
            this.productionVariants = x.productionVariants
            this.shadowProductionVariants = x.shadowProductionVariants
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateEndpointConfigRequest = CreateEndpointConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig] inside the given [block]
         */
        public fun asyncInferenceConfig(block: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.Builder.() -> kotlin.Unit) {
            this.asyncInferenceConfig = aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig] inside the given [block]
         */
        public fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig] inside the given [block]
         */
        public fun explainerConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig.Builder.() -> kotlin.Unit) {
            this.explainerConfig = aws.sdk.kotlin.services.sagemaker.model.ExplainerConfig.invoke(block)
        }
    }
}
