// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeInferenceExperimentResponse private constructor(builder: Builder) {
    /**
     * The ARN of the inference experiment being described.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp at which the inference experiment was completed.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The timestamp at which you created the inference experiment.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon S3 location and configuration for storing inference request and response data.
     */
    public val dataStorageConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig? = builder.dataStorageConfig
    /**
     * The description of the inference experiment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The metadata of the endpoint on which the inference experiment ran.
     */
    public val endpointMetadata: aws.sdk.kotlin.services.sagemaker.model.EndpointMetadata? = builder.endpointMetadata
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. For more information, see CreateInferenceExperimentRequest$KmsKey.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The timestamp at which you last modified the inference experiment.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * An array of `ModelVariantConfigSummary` objects. There is one for each variant in the inference experiment. Each `ModelVariantConfigSummary` object in the array describes the infrastructure configuration for deploying the corresponding variant.
     */
    public val modelVariants: List<ModelVariantConfigSummary>? = builder.modelVariants
    /**
     * The name of the inference experiment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The duration for which the inference experiment ran or will run.
     */
    public val schedule: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule? = builder.schedule
    /**
     * The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
     */
    public val shadowModeConfig: aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig? = builder.shadowModeConfig
    /**
     * The status of the inference experiment. The following are the possible statuses for an inference experiment:
     * + `Creating` - Amazon SageMaker is creating your experiment.
     * + `Created` - Amazon SageMaker has finished the creation of your experiment and will begin the experiment at the scheduled time.
     * + `Updating` - When you make changes to your experiment, your experiment shows as updating.
     * + `Starting` - Amazon SageMaker is beginning your experiment.
     * + `Running` - Your experiment is in progress.
     * + `Stopping` - Amazon SageMaker is stopping your experiment.
     * + `Completed` - Your experiment has completed.
     * + `Cancelled` - When you conclude your experiment early using the StopInferenceExperiment API, or if any operation fails with an unexpected error, it shows as cancelled.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentStatus? = builder.status
    /**
     * The error message or client-specified `Reason` from the StopInferenceExperiment API, that explains the status of the inference experiment.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The type of the inference experiment.
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceExperimentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInferenceExperimentResponse(")
        append("arn=$arn,")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("dataStorageConfig=$dataStorageConfig,")
        append("description=$description,")
        append("endpointMetadata=$endpointMetadata,")
        append("kmsKey=$kmsKey,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelVariants=$modelVariants,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("shadowModeConfig=$shadowModeConfig,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (completionTime?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataStorageConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointMetadata?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelVariants?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (shadowModeConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeInferenceExperimentResponse

        if (arn != other.arn) return false
        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (dataStorageConfig != other.dataStorageConfig) return false
        if (description != other.description) return false
        if (endpointMetadata != other.endpointMetadata) return false
        if (kmsKey != other.kmsKey) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelVariants != other.modelVariants) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (shadowModeConfig != other.shadowModeConfig) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceExperimentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the inference experiment being described.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp at which the inference experiment was completed.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp at which you created the inference experiment.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon S3 location and configuration for storing inference request and response data.
         */
        public var dataStorageConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig? = null
        /**
         * The description of the inference experiment.
         */
        public var description: kotlin.String? = null
        /**
         * The metadata of the endpoint on which the inference experiment ran.
         */
        public var endpointMetadata: aws.sdk.kotlin.services.sagemaker.model.EndpointMetadata? = null
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. For more information, see CreateInferenceExperimentRequest$KmsKey.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The timestamp at which you last modified the inference experiment.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of `ModelVariantConfigSummary` objects. There is one for each variant in the inference experiment. Each `ModelVariantConfigSummary` object in the array describes the infrastructure configuration for deploying the corresponding variant.
         */
        public var modelVariants: List<ModelVariantConfigSummary>? = null
        /**
         * The name of the inference experiment.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The duration for which the inference experiment ran or will run.
         */
        public var schedule: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule? = null
        /**
         * The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
         */
        public var shadowModeConfig: aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig? = null
        /**
         * The status of the inference experiment. The following are the possible statuses for an inference experiment:
         * + `Creating` - Amazon SageMaker is creating your experiment.
         * + `Created` - Amazon SageMaker has finished the creation of your experiment and will begin the experiment at the scheduled time.
         * + `Updating` - When you make changes to your experiment, your experiment shows as updating.
         * + `Starting` - Amazon SageMaker is beginning your experiment.
         * + `Running` - Your experiment is in progress.
         * + `Stopping` - Amazon SageMaker is stopping your experiment.
         * + `Completed` - Your experiment has completed.
         * + `Cancelled` - When you conclude your experiment early using the StopInferenceExperiment API, or if any operation fails with an unexpected error, it shows as cancelled.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentStatus? = null
        /**
         * The error message or client-specified `Reason` from the StopInferenceExperiment API, that explains the status of the inference experiment.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The type of the inference experiment.
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceExperimentResponse) : this() {
            this.arn = x.arn
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.dataStorageConfig = x.dataStorageConfig
            this.description = x.description
            this.endpointMetadata = x.endpointMetadata
            this.kmsKey = x.kmsKey
            this.lastModifiedTime = x.lastModifiedTime
            this.modelVariants = x.modelVariants
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.shadowModeConfig = x.shadowModeConfig
            this.status = x.status
            this.statusReason = x.statusReason
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceExperimentResponse = DescribeInferenceExperimentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig] inside the given [block]
         */
        public fun dataStorageConfig(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig.Builder.() -> kotlin.Unit) {
            this.dataStorageConfig = aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.EndpointMetadata] inside the given [block]
         */
        public fun endpointMetadata(block: aws.sdk.kotlin.services.sagemaker.model.EndpointMetadata.Builder.() -> kotlin.Unit) {
            this.endpointMetadata = aws.sdk.kotlin.services.sagemaker.model.EndpointMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig] inside the given [block]
         */
        public fun shadowModeConfig(block: aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig.Builder.() -> kotlin.Unit) {
            this.shadowModeConfig = aws.sdk.kotlin.services.sagemaker.model.ShadowModeConfig.invoke(block)
        }
    }
}
