// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeLabelingJobResponse private constructor(builder: Builder) {
    /**
     * The date and time that the labeling job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If the job failed, the reason that it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Configuration information required for human workers to complete a labeling task.
     */
    public val humanTaskConfig: aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig? = builder.humanTaskConfig
    /**
     * Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.
     */
    public val inputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig? = builder.inputConfig
    /**
     * A unique identifier for work done as part of a labeling job.
     */
    public val jobReferenceCode: kotlin.String? = builder.jobReferenceCode
    /**
     * The attribute used as the label in the output manifest file.
     */
    public val labelAttributeName: kotlin.String? = builder.labelAttributeName
    /**
     * The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:
     * + Semantic segmentation labeling jobs using automated labeling: 20 labels
     * + Box bounding labeling jobs (all): 10 labels
     *
     * The file is a JSON structure in the following format:
     *
     * `{`
     *
     * ` "document-version": "2018-11-28"`
     *
     * ` "labels": [`
     *
     * ` {`
     *
     * ` "label": "<i>label 1</i>"`
     *
     * ` },`
     *
     * ` {`
     *
     * ` "label": "<i>label 2</i>"`
     *
     * ` },`
     *
     * ` ...`
     *
     * ` {`
     *
     * ` "label": "<i>label n</i>"`
     *
     * ` }`
     *
     * ` ]`
     *
     * `}`
     */
    public val labelCategoryConfigS3Uri: kotlin.String? = builder.labelCategoryConfigS3Uri
    /**
     * Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled.
     */
    public val labelCounters: aws.sdk.kotlin.services.sagemaker.model.LabelCounters? = builder.labelCounters
    /**
     * Configuration information for automated data labeling.
     */
    public val labelingJobAlgorithmsConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig? = builder.labelingJobAlgorithmsConfig
    /**
     * The Amazon Resource Name (ARN) of the labeling job.
     */
    public val labelingJobArn: kotlin.String? = builder.labelingJobArn
    /**
     * The name assigned to the labeling job when it was created.
     */
    public val labelingJobName: kotlin.String? = builder.labelingJobName
    /**
     * The location of the output produced by the labeling job.
     */
    public val labelingJobOutput: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput? = builder.labelingJobOutput
    /**
     * The processing status of the labeling job.
     */
    public val labelingJobStatus: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStatus? = builder.labelingJobStatus
    /**
     * The date and time that the labeling job was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The location of the job's output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf during data labeling.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.
     */
    public val stoppingConditions: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions? = builder.stoppingConditions
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeLabelingJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLabelingJobResponse(")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("humanTaskConfig=$humanTaskConfig,")
        append("inputConfig=$inputConfig,")
        append("jobReferenceCode=$jobReferenceCode,")
        append("labelAttributeName=$labelAttributeName,")
        append("labelCategoryConfigS3Uri=$labelCategoryConfigS3Uri,")
        append("labelCounters=$labelCounters,")
        append("labelingJobAlgorithmsConfig=$labelingJobAlgorithmsConfig,")
        append("labelingJobArn=$labelingJobArn,")
        append("labelingJobName=$labelingJobName,")
        append("labelingJobOutput=$labelingJobOutput,")
        append("labelingJobStatus=$labelingJobStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("stoppingConditions=$stoppingConditions,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (humanTaskConfig?.hashCode() ?: 0)
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (jobReferenceCode?.hashCode() ?: 0)
        result = 31 * result + (labelAttributeName?.hashCode() ?: 0)
        result = 31 * result + (labelCategoryConfigS3Uri?.hashCode() ?: 0)
        result = 31 * result + (labelCounters?.hashCode() ?: 0)
        result = 31 * result + (labelingJobAlgorithmsConfig?.hashCode() ?: 0)
        result = 31 * result + (labelingJobArn?.hashCode() ?: 0)
        result = 31 * result + (labelingJobName?.hashCode() ?: 0)
        result = 31 * result + (labelingJobOutput?.hashCode() ?: 0)
        result = 31 * result + (labelingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingConditions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLabelingJobResponse

        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (humanTaskConfig != other.humanTaskConfig) return false
        if (inputConfig != other.inputConfig) return false
        if (jobReferenceCode != other.jobReferenceCode) return false
        if (labelAttributeName != other.labelAttributeName) return false
        if (labelCategoryConfigS3Uri != other.labelCategoryConfigS3Uri) return false
        if (labelCounters != other.labelCounters) return false
        if (labelingJobAlgorithmsConfig != other.labelingJobAlgorithmsConfig) return false
        if (labelingJobArn != other.labelingJobArn) return false
        if (labelingJobName != other.labelingJobName) return false
        if (labelingJobOutput != other.labelingJobOutput) return false
        if (labelingJobStatus != other.labelingJobStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingConditions != other.stoppingConditions) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeLabelingJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the labeling job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the job failed, the reason that it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Configuration information required for human workers to complete a labeling task.
         */
        public var humanTaskConfig: aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig? = null
        /**
         * Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.
         */
        public var inputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig? = null
        /**
         * A unique identifier for work done as part of a labeling job.
         */
        public var jobReferenceCode: kotlin.String? = null
        /**
         * The attribute used as the label in the output manifest file.
         */
        public var labelAttributeName: kotlin.String? = null
        /**
         * The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:
         * + Semantic segmentation labeling jobs using automated labeling: 20 labels
         * + Box bounding labeling jobs (all): 10 labels
         *
         * The file is a JSON structure in the following format:
         *
         * `{`
         *
         * ` "document-version": "2018-11-28"`
         *
         * ` "labels": [`
         *
         * ` {`
         *
         * ` "label": "<i>label 1</i>"`
         *
         * ` },`
         *
         * ` {`
         *
         * ` "label": "<i>label 2</i>"`
         *
         * ` },`
         *
         * ` ...`
         *
         * ` {`
         *
         * ` "label": "<i>label n</i>"`
         *
         * ` }`
         *
         * ` ]`
         *
         * `}`
         */
        public var labelCategoryConfigS3Uri: kotlin.String? = null
        /**
         * Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled.
         */
        public var labelCounters: aws.sdk.kotlin.services.sagemaker.model.LabelCounters? = null
        /**
         * Configuration information for automated data labeling.
         */
        public var labelingJobAlgorithmsConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the labeling job.
         */
        public var labelingJobArn: kotlin.String? = null
        /**
         * The name assigned to the labeling job when it was created.
         */
        public var labelingJobName: kotlin.String? = null
        /**
         * The location of the output produced by the labeling job.
         */
        public var labelingJobOutput: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput? = null
        /**
         * The processing status of the labeling job.
         */
        public var labelingJobStatus: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStatus? = null
        /**
         * The date and time that the labeling job was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the job's output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf during data labeling.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.
         */
        public var stoppingConditions: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeLabelingJobResponse) : this() {
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.humanTaskConfig = x.humanTaskConfig
            this.inputConfig = x.inputConfig
            this.jobReferenceCode = x.jobReferenceCode
            this.labelAttributeName = x.labelAttributeName
            this.labelCategoryConfigS3Uri = x.labelCategoryConfigS3Uri
            this.labelCounters = x.labelCounters
            this.labelingJobAlgorithmsConfig = x.labelingJobAlgorithmsConfig
            this.labelingJobArn = x.labelingJobArn
            this.labelingJobName = x.labelingJobName
            this.labelingJobOutput = x.labelingJobOutput
            this.labelingJobStatus = x.labelingJobStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.stoppingConditions = x.stoppingConditions
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeLabelingJobResponse = DescribeLabelingJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig] inside the given [block]
         */
        public fun humanTaskConfig(block: aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig.Builder.() -> kotlin.Unit) {
            this.humanTaskConfig = aws.sdk.kotlin.services.sagemaker.model.HumanTaskConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig] inside the given [block]
         */
        public fun inputConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelCounters] inside the given [block]
         */
        public fun labelCounters(block: aws.sdk.kotlin.services.sagemaker.model.LabelCounters.Builder.() -> kotlin.Unit) {
            this.labelCounters = aws.sdk.kotlin.services.sagemaker.model.LabelCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig] inside the given [block]
         */
        public fun labelingJobAlgorithmsConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig.Builder.() -> kotlin.Unit) {
            this.labelingJobAlgorithmsConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput] inside the given [block]
         */
        public fun labelingJobOutput(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput.Builder.() -> kotlin.Unit) {
            this.labelingJobOutput = aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions] inside the given [block]
         */
        public fun stoppingConditions(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions.Builder.() -> kotlin.Unit) {
            this.stoppingConditions = aws.sdk.kotlin.services.sagemaker.model.LabelingJobStoppingConditions.invoke(block)
        }
    }
}
