// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information summarizing an edge deployment plan.
 */
public class EdgeDeploymentPlanSummary private constructor(builder: Builder) {
    /**
     * The time when the edge deployment plan was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the device fleet used for the deployment.
     */
    public val deviceFleetName: kotlin.String? = builder.deviceFleetName
    /**
     * The number of edge devices that failed the deployment.
     */
    public val edgeDeploymentFailed: kotlin.Int = builder.edgeDeploymentFailed
    /**
     * The number of edge devices yet to pick up the deployment, or in progress.
     */
    public val edgeDeploymentPending: kotlin.Int = builder.edgeDeploymentPending
    /**
     * The ARN of the edge deployment plan.
     */
    public val edgeDeploymentPlanArn: kotlin.String? = builder.edgeDeploymentPlanArn
    /**
     * The name of the edge deployment plan.
     */
    public val edgeDeploymentPlanName: kotlin.String? = builder.edgeDeploymentPlanName
    /**
     * The number of edge devices with the successful deployment.
     */
    public val edgeDeploymentSuccess: kotlin.Int = builder.edgeDeploymentSuccess
    /**
     * The time when the edge deployment plan was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentPlanSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EdgeDeploymentPlanSummary(")
        append("creationTime=$creationTime,")
        append("deviceFleetName=$deviceFleetName,")
        append("edgeDeploymentFailed=$edgeDeploymentFailed,")
        append("edgeDeploymentPending=$edgeDeploymentPending,")
        append("edgeDeploymentPlanArn=$edgeDeploymentPlanArn,")
        append("edgeDeploymentPlanName=$edgeDeploymentPlanName,")
        append("edgeDeploymentSuccess=$edgeDeploymentSuccess,")
        append("lastModifiedTime=$lastModifiedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deviceFleetName?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentFailed)
        result = 31 * result + (edgeDeploymentPending)
        result = 31 * result + (edgeDeploymentPlanArn?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentPlanName?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentSuccess)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EdgeDeploymentPlanSummary

        if (creationTime != other.creationTime) return false
        if (deviceFleetName != other.deviceFleetName) return false
        if (edgeDeploymentFailed != other.edgeDeploymentFailed) return false
        if (edgeDeploymentPending != other.edgeDeploymentPending) return false
        if (edgeDeploymentPlanArn != other.edgeDeploymentPlanArn) return false
        if (edgeDeploymentPlanName != other.edgeDeploymentPlanName) return false
        if (edgeDeploymentSuccess != other.edgeDeploymentSuccess) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentPlanSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the edge deployment plan was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the device fleet used for the deployment.
         */
        public var deviceFleetName: kotlin.String? = null
        /**
         * The number of edge devices that failed the deployment.
         */
        public var edgeDeploymentFailed: kotlin.Int = 0
        /**
         * The number of edge devices yet to pick up the deployment, or in progress.
         */
        public var edgeDeploymentPending: kotlin.Int = 0
        /**
         * The ARN of the edge deployment plan.
         */
        public var edgeDeploymentPlanArn: kotlin.String? = null
        /**
         * The name of the edge deployment plan.
         */
        public var edgeDeploymentPlanName: kotlin.String? = null
        /**
         * The number of edge devices with the successful deployment.
         */
        public var edgeDeploymentSuccess: kotlin.Int = 0
        /**
         * The time when the edge deployment plan was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentPlanSummary) : this() {
            this.creationTime = x.creationTime
            this.deviceFleetName = x.deviceFleetName
            this.edgeDeploymentFailed = x.edgeDeploymentFailed
            this.edgeDeploymentPending = x.edgeDeploymentPending
            this.edgeDeploymentPlanArn = x.edgeDeploymentPlanArn
            this.edgeDeploymentPlanName = x.edgeDeploymentPlanName
            this.edgeDeploymentSuccess = x.edgeDeploymentSuccess
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentPlanSummary = EdgeDeploymentPlanSummary(this)
    }
}
