// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies configuration details for a Git repository in your Amazon Web Services account.
 */
public class GitConfig private constructor(builder: Builder) {
    /**
     * The default branch for the Git repository.
     */
    public val branch: kotlin.String? = builder.branch
    /**
     * The URL where the Git repository is located.
     */
    public val repositoryUrl: kotlin.String? = builder.repositoryUrl
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of `AWSCURRENT` and must be in the following format:
     *
     * `{"username": <i>UserName</i>, "password": <i>Password</i>}`
     */
    public val secretArn: kotlin.String? = builder.secretArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.GitConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GitConfig(")
        append("branch=$branch,")
        append("repositoryUrl=$repositoryUrl,")
        append("secretArn=$secretArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branch?.hashCode() ?: 0
        result = 31 * result + (repositoryUrl?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GitConfig

        if (branch != other.branch) return false
        if (repositoryUrl != other.repositoryUrl) return false
        if (secretArn != other.secretArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.GitConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default branch for the Git repository.
         */
        public var branch: kotlin.String? = null
        /**
         * The URL where the Git repository is located.
         */
        public var repositoryUrl: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of `AWSCURRENT` and must be in the following format:
         *
         * `{"username": <i>UserName</i>, "password": <i>Password</i>}`
         */
        public var secretArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.GitConfig) : this() {
            this.branch = x.branch
            this.repositoryUrl = x.repositoryUrl
            this.secretArn = x.secretArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.GitConfig = GitConfig(this)
    }
}
