// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines a hyperparameter to be used by an algorithm.
 */
public class HyperParameterSpecification private constructor(builder: Builder) {
    /**
     * The default value for this hyperparameter. If a default value is specified, a hyperparameter cannot be required.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * A brief description of the hyperparameter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether this hyperparameter is required.
     */
    public val isRequired: kotlin.Boolean = builder.isRequired
    /**
     * Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.
     */
    public val isTunable: kotlin.Boolean = builder.isTunable
    /**
     * The name of this hyperparameter. The name must be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The allowed range for this hyperparameter.
     */
    public val range: aws.sdk.kotlin.services.sagemaker.model.ParameterRange? = builder.range
    /**
     * The type of this hyperparameter. The valid types are `Integer`, `Continuous`, `Categorical`, and `FreeText`.
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.ParameterType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterSpecification(")
        append("defaultValue=$defaultValue,")
        append("description=$description,")
        append("isRequired=$isRequired,")
        append("isTunable=$isTunable,")
        append("name=$name,")
        append("range=$range,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValue?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isRequired.hashCode())
        result = 31 * result + (isTunable.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (range?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterSpecification

        if (defaultValue != other.defaultValue) return false
        if (description != other.description) return false
        if (isRequired != other.isRequired) return false
        if (isTunable != other.isTunable) return false
        if (name != other.name) return false
        if (range != other.range) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default value for this hyperparameter. If a default value is specified, a hyperparameter cannot be required.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * A brief description of the hyperparameter.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether this hyperparameter is required.
         */
        public var isRequired: kotlin.Boolean = false
        /**
         * Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.
         */
        public var isTunable: kotlin.Boolean = false
        /**
         * The name of this hyperparameter. The name must be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The allowed range for this hyperparameter.
         */
        public var range: aws.sdk.kotlin.services.sagemaker.model.ParameterRange? = null
        /**
         * The type of this hyperparameter. The valid types are `Integer`, `Continuous`, `Categorical`, and `FreeText`.
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.ParameterType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterSpecification) : this() {
            this.defaultValue = x.defaultValue
            this.description = x.description
            this.isRequired = x.isRequired
            this.isTunable = x.isTunable
            this.name = x.name
            this.range = x.range
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterSpecification = HyperParameterSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ParameterRange] inside the given [block]
         */
        public fun range(block: aws.sdk.kotlin.services.sagemaker.model.ParameterRange.Builder.() -> kotlin.Unit) {
            this.range = aws.sdk.kotlin.services.sagemaker.model.ParameterRange.invoke(block)
        }
    }
}
