// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The configuration for hyperparameter tuning resources for use in training jobs launched by the tuning job. These resources include compute instances and storage volumes. Specify one or more compute instance configurations and allocation strategies to select resources (optional).
 */
public class HyperParameterTuningInstanceConfig private constructor(builder: Builder) {
    /**
     * The number of instances of the type specified by `InstanceType`. Choose an instance count larger than 1 for distributed training algorithms. See [SageMaker distributed training jobs](https://docs.aws.amazon.com/data-parallel-use-api.html) for more informcration.
     */
    public val instanceCount: kotlin.Int = builder.instanceCount
    /**
     * The instance type used for processing of hyperparameter optimization jobs. Choose from general purpose (no GPUs) instance types: ml.m5.xlarge, ml.m5.2xlarge, and ml.m5.4xlarge or compute optimized (no GPUs) instance types: ml.c5.xlarge and ml.c5.2xlarge. For more information about instance types, see [instance type descriptions](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.TrainingInstanceType? = builder.instanceType
    /**
     * The volume size in GB of the data to be processed for hyperparameter optimization (optional).
     */
    public val volumeSizeInGb: kotlin.Int = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningInstanceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTuningInstanceConfig(")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceCount
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTuningInstanceConfig

        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningInstanceConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of instances of the type specified by `InstanceType`. Choose an instance count larger than 1 for distributed training algorithms. See [SageMaker distributed training jobs](https://docs.aws.amazon.com/data-parallel-use-api.html) for more informcration.
         */
        public var instanceCount: kotlin.Int = 0
        /**
         * The instance type used for processing of hyperparameter optimization jobs. Choose from general purpose (no GPUs) instance types: ml.m5.xlarge, ml.m5.2xlarge, and ml.m5.4xlarge or compute optimized (no GPUs) instance types: ml.c5.xlarge and ml.c5.2xlarge. For more information about instance types, see [instance type descriptions](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.TrainingInstanceType? = null
        /**
         * The volume size in GB of the data to be processed for hyperparameter optimization (optional).
         */
        public var volumeSizeInGb: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningInstanceConfig) : this() {
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningInstanceConfig = HyperParameterTuningInstanceConfig(this)
    }
}
