// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies a metric that the training algorithm writes to `stderr` or `stdout`. SageMakerhyperparameter tuning captures all defined metrics. You specify one metric that a hyperparameter tuning job uses as its objective metric to choose the best training job.
 */
public class MetricDefinition private constructor(builder: Builder) {
    /**
     * The name of the metric.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A regular expression that searches the output of a training job and gets the value of the metric. For more information about using regular expressions to define metrics, see [Defining Objective Metrics](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html).
     */
    public val regex: kotlin.String? = builder.regex

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MetricDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricDefinition(")
        append("name=$name,")
        append("regex=$regex")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (regex?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricDefinition

        if (name != other.name) return false
        if (regex != other.regex) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MetricDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the metric.
         */
        public var name: kotlin.String? = null
        /**
         * A regular expression that searches the output of a training job and gets the value of the metric. For more information about using regular expressions to define metrics, see [Defining Objective Metrics](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html).
         */
        public var regex: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MetricDefinition) : this() {
            this.name = x.name
            this.regex = x.regex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MetricDefinition = MetricDefinition(this)
    }
}
