// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.
 *
 * The maximum number of items specified for `Array Members` refers to the maximum number of hyperparameters for each range and also the maximum for the hyperparameter tuning job itself. That is, the sum of the number of hyperparameters for all the ranges can't exceed the maximum number specified.
 */
public class ParameterRanges private constructor(builder: Builder) {
    /**
     * The array of CategoricalParameterRange objects that specify ranges of categorical hyperparameters that a hyperparameter tuning job searches.
     */
    public val categoricalParameterRanges: List<CategoricalParameterRange>? = builder.categoricalParameterRanges
    /**
     * The array of ContinuousParameterRange objects that specify ranges of continuous hyperparameters that a hyperparameter tuning job searches.
     */
    public val continuousParameterRanges: List<ContinuousParameterRange>? = builder.continuousParameterRanges
    /**
     * The array of IntegerParameterRange objects that specify ranges of integer hyperparameters that a hyperparameter tuning job searches.
     */
    public val integerParameterRanges: List<IntegerParameterRange>? = builder.integerParameterRanges

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ParameterRanges = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterRanges(")
        append("categoricalParameterRanges=$categoricalParameterRanges,")
        append("continuousParameterRanges=$continuousParameterRanges,")
        append("integerParameterRanges=$integerParameterRanges")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categoricalParameterRanges?.hashCode() ?: 0
        result = 31 * result + (continuousParameterRanges?.hashCode() ?: 0)
        result = 31 * result + (integerParameterRanges?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterRanges

        if (categoricalParameterRanges != other.categoricalParameterRanges) return false
        if (continuousParameterRanges != other.continuousParameterRanges) return false
        if (integerParameterRanges != other.integerParameterRanges) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ParameterRanges = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The array of CategoricalParameterRange objects that specify ranges of categorical hyperparameters that a hyperparameter tuning job searches.
         */
        public var categoricalParameterRanges: List<CategoricalParameterRange>? = null
        /**
         * The array of ContinuousParameterRange objects that specify ranges of continuous hyperparameters that a hyperparameter tuning job searches.
         */
        public var continuousParameterRanges: List<ContinuousParameterRange>? = null
        /**
         * The array of IntegerParameterRange objects that specify ranges of integer hyperparameters that a hyperparameter tuning job searches.
         */
        public var integerParameterRanges: List<IntegerParameterRange>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges) : this() {
            this.categoricalParameterRanges = x.categoricalParameterRanges
            this.continuousParameterRanges = x.continuousParameterRanges
            this.integerParameterRanges = x.integerParameterRanges
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ParameterRanges = ParameterRanges(this)
    }
}
