// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An execution of a step in a pipeline.
 */
public class PipelineExecutionStep private constructor(builder: Builder) {
    /**
     * The current attempt of the execution step. For more information, see [Retry Policy for SageMaker Pipelines steps](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-retry-policy.html).
     */
    public val attemptCount: kotlin.Int = builder.attemptCount
    /**
     * If this pipeline execution step was cached, details on the cache hit.
     */
    public val cacheHitResult: aws.sdk.kotlin.services.sagemaker.model.CacheHitResult? = builder.cacheHitResult
    /**
     * The time that the step stopped executing.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The reason why the step failed execution. This is only returned if the step failed its execution.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Metadata to run the pipeline step.
     */
    public val metadata: aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStepMetadata? = builder.metadata
    /**
     * The time that the step started executing.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The description of the step.
     */
    public val stepDescription: kotlin.String? = builder.stepDescription
    /**
     * The display name of the step.
     */
    public val stepDisplayName: kotlin.String? = builder.stepDisplayName
    /**
     * The name of the step that is executed.
     */
    public val stepName: kotlin.String? = builder.stepName
    /**
     * The status of the step execution.
     */
    public val stepStatus: aws.sdk.kotlin.services.sagemaker.model.StepStatus? = builder.stepStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStep = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipelineExecutionStep(")
        append("attemptCount=$attemptCount,")
        append("cacheHitResult=$cacheHitResult,")
        append("endTime=$endTime,")
        append("failureReason=$failureReason,")
        append("metadata=$metadata,")
        append("startTime=$startTime,")
        append("stepDescription=$stepDescription,")
        append("stepDisplayName=$stepDisplayName,")
        append("stepName=$stepName,")
        append("stepStatus=$stepStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attemptCount
        result = 31 * result + (cacheHitResult?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (stepDescription?.hashCode() ?: 0)
        result = 31 * result + (stepDisplayName?.hashCode() ?: 0)
        result = 31 * result + (stepName?.hashCode() ?: 0)
        result = 31 * result + (stepStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipelineExecutionStep

        if (attemptCount != other.attemptCount) return false
        if (cacheHitResult != other.cacheHitResult) return false
        if (endTime != other.endTime) return false
        if (failureReason != other.failureReason) return false
        if (metadata != other.metadata) return false
        if (startTime != other.startTime) return false
        if (stepDescription != other.stepDescription) return false
        if (stepDisplayName != other.stepDisplayName) return false
        if (stepName != other.stepName) return false
        if (stepStatus != other.stepStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStep = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The current attempt of the execution step. For more information, see [Retry Policy for SageMaker Pipelines steps](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-retry-policy.html).
         */
        public var attemptCount: kotlin.Int = 0
        /**
         * If this pipeline execution step was cached, details on the cache hit.
         */
        public var cacheHitResult: aws.sdk.kotlin.services.sagemaker.model.CacheHitResult? = null
        /**
         * The time that the step stopped executing.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason why the step failed execution. This is only returned if the step failed its execution.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Metadata to run the pipeline step.
         */
        public var metadata: aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStepMetadata? = null
        /**
         * The time that the step started executing.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the step.
         */
        public var stepDescription: kotlin.String? = null
        /**
         * The display name of the step.
         */
        public var stepDisplayName: kotlin.String? = null
        /**
         * The name of the step that is executed.
         */
        public var stepName: kotlin.String? = null
        /**
         * The status of the step execution.
         */
        public var stepStatus: aws.sdk.kotlin.services.sagemaker.model.StepStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStep) : this() {
            this.attemptCount = x.attemptCount
            this.cacheHitResult = x.cacheHitResult
            this.endTime = x.endTime
            this.failureReason = x.failureReason
            this.metadata = x.metadata
            this.startTime = x.startTime
            this.stepDescription = x.stepDescription
            this.stepDisplayName = x.stepDisplayName
            this.stepName = x.stepName
            this.stepStatus = x.stepStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStep = PipelineExecutionStep(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CacheHitResult] inside the given [block]
         */
        public fun cacheHitResult(block: aws.sdk.kotlin.services.sagemaker.model.CacheHitResult.Builder.() -> kotlin.Unit) {
            this.cacheHitResult = aws.sdk.kotlin.services.sagemaker.model.CacheHitResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStepMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStepMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStepMetadata.invoke(block)
        }
    }
}
