// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration for uploading output from the processing container.
 */
public class ProcessingOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the processing job output. `KmsKeyId` can be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key. The `KmsKeyId` is applied to all outputs.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * An array of outputs configuring the data to upload from the processing container.
     */
    public val outputs: List<ProcessingOutput>? = builder.outputs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessingOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("outputs=$outputs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (outputs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessingOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (outputs != other.outputs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the processing job output. `KmsKeyId` can be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key. The `KmsKeyId` is applied to all outputs.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * An array of outputs configuring the data to upload from the processing container.
         */
        public var outputs: List<ProcessingOutput>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.outputs = x.outputs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig = ProcessingOutputConfig(this)
    }
}
