// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Identifies a model that you want to host and the resources chosen to deploy for hosting it. If you are deploying multiple models, tell SageMaker how to distribute traffic among the models by specifying variant weights.
 */
public class ProductionVariant private constructor(builder: Builder) {
    /**
     * The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see [Using Elastic Inference in Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
     */
    public val acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = builder.acceleratorType
    /**
     * The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests).
     */
    public val containerStartupHealthCheckTimeoutInSeconds: kotlin.Int? = builder.containerStartupHealthCheckTimeoutInSeconds
    /**
     * Specifies configuration for a core dump from the model container when the process crashes.
     */
    public val coreDumpConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig? = builder.coreDumpConfig
    /**
     * Number of instances to launch initially.
     */
    public val initialInstanceCount: kotlin.Int? = builder.initialInstanceCount
    /**
     * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the `VariantWeight` to the sum of all `VariantWeight` values across all ProductionVariants. If unspecified, it defaults to 1.0.
     */
    public val initialVariantWeight: kotlin.Float? = builder.initialVariantWeight
    /**
     * The ML compute instance type.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = builder.instanceType
    /**
     * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
     */
    public val modelDataDownloadTimeoutInSeconds: kotlin.Int? = builder.modelDataDownloadTimeoutInSeconds
    /**
     * The name of the model that you want to host. This is the name that you specified when creating the model.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
     */
    public val serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = builder.serverlessConfig
    /**
     * The name of the production variant.
     */
    public val variantName: kotlin.String? = builder.variantName
    /**
     * The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Currenly only Amazon EBS gp2 storage volumes are supported.
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductionVariant(")
        append("acceleratorType=$acceleratorType,")
        append("containerStartupHealthCheckTimeoutInSeconds=$containerStartupHealthCheckTimeoutInSeconds,")
        append("coreDumpConfig=$coreDumpConfig,")
        append("initialInstanceCount=$initialInstanceCount,")
        append("initialVariantWeight=$initialVariantWeight,")
        append("instanceType=$instanceType,")
        append("modelDataDownloadTimeoutInSeconds=$modelDataDownloadTimeoutInSeconds,")
        append("modelName=$modelName,")
        append("serverlessConfig=$serverlessConfig,")
        append("variantName=$variantName,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorType?.hashCode() ?: 0
        result = 31 * result + (containerStartupHealthCheckTimeoutInSeconds ?: 0)
        result = 31 * result + (coreDumpConfig?.hashCode() ?: 0)
        result = 31 * result + (initialInstanceCount ?: 0)
        result = 31 * result + (initialVariantWeight?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (modelDataDownloadTimeoutInSeconds ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (serverlessConfig?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductionVariant

        if (acceleratorType != other.acceleratorType) return false
        if (containerStartupHealthCheckTimeoutInSeconds != other.containerStartupHealthCheckTimeoutInSeconds) return false
        if (coreDumpConfig != other.coreDumpConfig) return false
        if (initialInstanceCount != other.initialInstanceCount) return false
        if (initialVariantWeight != other.initialVariantWeight) return false
        if (instanceType != other.instanceType) return false
        if (modelDataDownloadTimeoutInSeconds != other.modelDataDownloadTimeoutInSeconds) return false
        if (modelName != other.modelName) return false
        if (serverlessConfig != other.serverlessConfig) return false
        if (variantName != other.variantName) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see [Using Elastic Inference in Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
         */
        public var acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = null
        /**
         * The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests).
         */
        public var containerStartupHealthCheckTimeoutInSeconds: kotlin.Int? = null
        /**
         * Specifies configuration for a core dump from the model container when the process crashes.
         */
        public var coreDumpConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig? = null
        /**
         * Number of instances to launch initially.
         */
        public var initialInstanceCount: kotlin.Int? = null
        /**
         * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the `VariantWeight` to the sum of all `VariantWeight` values across all ProductionVariants. If unspecified, it defaults to 1.0.
         */
        public var initialVariantWeight: kotlin.Float? = null
        /**
         * The ML compute instance type.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = null
        /**
         * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
         */
        public var modelDataDownloadTimeoutInSeconds: kotlin.Int? = null
        /**
         * The name of the model that you want to host. This is the name that you specified when creating the model.
         */
        public var modelName: kotlin.String? = null
        /**
         * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
         */
        public var serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = null
        /**
         * The name of the production variant.
         */
        public var variantName: kotlin.String? = null
        /**
         * The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Currenly only Amazon EBS gp2 storage volumes are supported.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProductionVariant) : this() {
            this.acceleratorType = x.acceleratorType
            this.containerStartupHealthCheckTimeoutInSeconds = x.containerStartupHealthCheckTimeoutInSeconds
            this.coreDumpConfig = x.coreDumpConfig
            this.initialInstanceCount = x.initialInstanceCount
            this.initialVariantWeight = x.initialVariantWeight
            this.instanceType = x.instanceType
            this.modelDataDownloadTimeoutInSeconds = x.modelDataDownloadTimeoutInSeconds
            this.modelName = x.modelName
            this.serverlessConfig = x.serverlessConfig
            this.variantName = x.variantName
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = ProductionVariant(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig] inside the given [block]
         */
        public fun coreDumpConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig.Builder.() -> kotlin.Unit) {
            this.coreDumpConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig] inside the given [block]
         */
        public fun serverlessConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.Builder.() -> kotlin.Unit) {
            this.serverlessConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.invoke(block)
        }
    }
}
