// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class SearchRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If more than `MaxResults` resources match the specified `SearchExpression`, the response includes a `NextToken`. The `NextToken` can be passed to the next `SearchRequest` to continue retrieving results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the Amazon SageMaker resource to search for.
     */
    public val resource: aws.sdk.kotlin.services.sagemaker.model.ResourceType? = builder.resource
    /**
     * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive `SubExpressions`, `NestedFilters`, and `Filters` that can be included in a `SearchExpression` object is 50.
     */
    public val searchExpression: aws.sdk.kotlin.services.sagemaker.model.SearchExpression? = builder.searchExpression
    /**
     * The name of the resource property used to sort the `SearchResults`. The default is `LastModifiedTime`.
     */
    public val sortBy: kotlin.String? = builder.sortBy
    /**
     * How `SearchResults` are ordered. Valid values are `Ascending` or `Descending`. The default is `Descending`.
     */
    public val sortOrder: aws.sdk.kotlin.services.sagemaker.model.SearchSortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SearchRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resource=$resource,")
        append("searchExpression=$searchExpression,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (searchExpression?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resource != other.resource) return false
        if (searchExpression != other.searchExpression) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SearchRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If more than `MaxResults` resources match the specified `SearchExpression`, the response includes a `NextToken`. The `NextToken` can be passed to the next `SearchRequest` to continue retrieving results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the Amazon SageMaker resource to search for.
         */
        public var resource: aws.sdk.kotlin.services.sagemaker.model.ResourceType? = null
        /**
         * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive `SubExpressions`, `NestedFilters`, and `Filters` that can be included in a `SearchExpression` object is 50.
         */
        public var searchExpression: aws.sdk.kotlin.services.sagemaker.model.SearchExpression? = null
        /**
         * The name of the resource property used to sort the `SearchResults`. The default is `LastModifiedTime`.
         */
        public var sortBy: kotlin.String? = null
        /**
         * How `SearchResults` are ordered. Valid values are `Ascending` or `Descending`. The default is `Descending`.
         */
        public var sortOrder: aws.sdk.kotlin.services.sagemaker.model.SearchSortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SearchRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resource = x.resource
            this.searchExpression = x.searchExpression
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SearchRequest = SearchRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SearchExpression] inside the given [block]
         */
        public fun searchExpression(block: aws.sdk.kotlin.services.sagemaker.model.SearchExpression.Builder.() -> kotlin.Unit) {
            this.searchExpression = aws.sdk.kotlin.services.sagemaker.model.SearchExpression.invoke(block)
        }
    }
}
