// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the resources, including ML instance types and ML instance count, to use for transform job.
 */
public class TransformResources private constructor(builder: Builder) {
    /**
     * The number of ML compute instances to use in the transform job. The default value is `1`, and the maximum is `100`. For distributed transform jobs, specify a value greater than `1`.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or `ml.m5.large`instance types.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.TransformInstanceType? = builder.instanceType
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.
     *
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a `VolumeKmsKeyId` when using an instance type with local storage.
     *
     * For a list of instance types that support local instance storage, see [Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
     *
     * For more information about local instance storage encryption, see [SSD Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
     *
     *  The `VolumeKmsKeyId` can be any of the following formats:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TransformResources = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransformResources(")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("volumeKmsKeyId=$volumeKmsKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceCount ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransformResources

        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TransformResources = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of ML compute instances to use in the transform job. The default value is `1`, and the maximum is `100`. For distributed transform jobs, specify a value greater than `1`.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or `ml.m5.large`instance types.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.TransformInstanceType? = null
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.
         *
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a `VolumeKmsKeyId` when using an instance type with local storage.
         *
         * For a list of instance types that support local instance storage, see [Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
         *
         * For more information about local instance storage encryption, see [SSD Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
         *
         *  The `VolumeKmsKeyId` can be any of the following formats:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
         */
        public var volumeKmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TransformResources) : this() {
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.volumeKmsKeyId = x.volumeKmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TransformResources = TransformResources(this)
    }
}
