// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Detailed information about the source of a trial component. Either `ProcessingJob` or `TrainingJob` is returned.
 */
public class TrialComponentSourceDetail private constructor(builder: Builder) {
    /**
     * Information about a processing job that's the source of a trial component.
     */
    public val processingJob: aws.sdk.kotlin.services.sagemaker.model.ProcessingJob? = builder.processingJob
    /**
     * The Amazon Resource Name (ARN) of the source.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * Information about a training job that's the source of a trial component.
     */
    public val trainingJob: aws.sdk.kotlin.services.sagemaker.model.TrainingJob? = builder.trainingJob
    /**
     * Information about a transform job that's the source of a trial component.
     */
    public val transformJob: aws.sdk.kotlin.services.sagemaker.model.TransformJob? = builder.transformJob

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrialComponentSourceDetail(")
        append("processingJob=$processingJob,")
        append("sourceArn=$sourceArn,")
        append("trainingJob=$trainingJob,")
        append("transformJob=$transformJob")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = processingJob?.hashCode() ?: 0
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (trainingJob?.hashCode() ?: 0)
        result = 31 * result + (transformJob?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrialComponentSourceDetail

        if (processingJob != other.processingJob) return false
        if (sourceArn != other.sourceArn) return false
        if (trainingJob != other.trainingJob) return false
        if (transformJob != other.transformJob) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about a processing job that's the source of a trial component.
         */
        public var processingJob: aws.sdk.kotlin.services.sagemaker.model.ProcessingJob? = null
        /**
         * The Amazon Resource Name (ARN) of the source.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * Information about a training job that's the source of a trial component.
         */
        public var trainingJob: aws.sdk.kotlin.services.sagemaker.model.TrainingJob? = null
        /**
         * Information about a transform job that's the source of a trial component.
         */
        public var transformJob: aws.sdk.kotlin.services.sagemaker.model.TransformJob? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail) : this() {
            this.processingJob = x.processingJob
            this.sourceArn = x.sourceArn
            this.trainingJob = x.trainingJob
            this.transformJob = x.transformJob
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrialComponentSourceDetail = TrialComponentSourceDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingJob] inside the given [block]
         */
        public fun processingJob(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingJob.Builder.() -> kotlin.Unit) {
            this.processingJob = aws.sdk.kotlin.services.sagemaker.model.ProcessingJob.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrainingJob] inside the given [block]
         */
        public fun trainingJob(block: aws.sdk.kotlin.services.sagemaker.model.TrainingJob.Builder.() -> kotlin.Unit) {
            this.trainingJob = aws.sdk.kotlin.services.sagemaker.model.TrainingJob.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformJob] inside the given [block]
         */
        public fun transformJob(block: aws.sdk.kotlin.services.sagemaker.model.TransformJob.Builder.() -> kotlin.Unit) {
            this.transformJob = aws.sdk.kotlin.services.sagemaker.model.TransformJob.invoke(block)
        }
    }
}
