// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class UpdateModelCardRequest private constructor(builder: Builder) {
    /**
     * The updated model card content. Content must be in [model card JSON schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-api-json-schema.html) and provided as a string.
     *
     * When updating model card content, be sure to include the full content and not just updated content.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The name of the model card to update.
     */
    public val modelCardName: kotlin.String? = builder.modelCardName
    /**
     * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
     * + `Draft`: The model card is a work in progress.
     * + `PendingReview`: The model card is pending review.
     * + `Approved`: The model card is approved.
     * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateModelCardRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateModelCardRequest(")
        append("content=*** Sensitive Data Redacted ***,")
        append("modelCardName=$modelCardName,")
        append("modelCardStatus=$modelCardStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (modelCardName?.hashCode() ?: 0)
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateModelCardRequest

        if (content != other.content) return false
        if (modelCardName != other.modelCardName) return false
        if (modelCardStatus != other.modelCardStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateModelCardRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The updated model card content. Content must be in [model card JSON schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-api-json-schema.html) and provided as a string.
         *
         * When updating model card content, be sure to include the full content and not just updated content.
         */
        public var content: kotlin.String? = null
        /**
         * The name of the model card to update.
         */
        public var modelCardName: kotlin.String? = null
        /**
         * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
         * + `Draft`: The model card is a work in progress.
         * + `PendingReview`: The model card is pending review.
         * + `Approved`: The model card is approved.
         * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateModelCardRequest) : this() {
            this.content = x.content
            this.modelCardName = x.modelCardName
            this.modelCardStatus = x.modelCardStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateModelCardRequest = UpdateModelCardRequest(this)
    }
}
