// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.AppStatus
import aws.sdk.kotlin.services.sagemaker.model.AppType
import aws.sdk.kotlin.services.sagemaker.model.DescribeAppResponse
import aws.sdk.kotlin.services.sagemaker.model.ResourceSpec
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAppOperationDeserializer: HttpDeserialize<DescribeAppResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAppResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAppError(context, response)
        }
        val builder = DescribeAppResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAppOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAppError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAppOperationBody(builder: DescribeAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppArn"))
    val APPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppName"))
    val APPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AppType"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTHEALTHCHECKTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastHealthCheckTimestamp"))
    val LASTUSERACTIVITYTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUserActivityTimestamp"))
    val RESOURCESPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceSpec"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpaceName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val USERPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserProfileName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(APPNAME_DESCRIPTOR)
        field(APPTYPE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTHEALTHCHECKTIMESTAMP_DESCRIPTOR)
        field(LASTUSERACTIVITYTIMESTAMP_DESCRIPTOR)
        field(RESOURCESPEC_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERPROFILENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                APPNAME_DESCRIPTOR.index -> builder.appName = deserializeString()
                APPTYPE_DESCRIPTOR.index -> builder.appType = deserializeString().let { AppType.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTHEALTHCHECKTIMESTAMP_DESCRIPTOR.index -> builder.lastHealthCheckTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUSERACTIVITYTIMESTAMP_DESCRIPTOR.index -> builder.lastUserActivityTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESOURCESPEC_DESCRIPTOR.index -> builder.resourceSpec = deserializeResourceSpecDocument(deserializer)
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AppStatus.fromValue(it) }
                USERPROFILENAME_DESCRIPTOR.index -> builder.userProfileName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
