// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.ArtifactSource
import aws.sdk.kotlin.services.sagemaker.model.DescribeArtifactResponse
import aws.sdk.kotlin.services.sagemaker.model.MetadataProperties
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class DescribeArtifactOperationDeserializer: HttpDeserialize<DescribeArtifactResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeArtifactResponse {
        if (!response.status.isSuccess()) {
            throwDescribeArtifactError(context, response)
        }
        val builder = DescribeArtifactResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeArtifactOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeArtifactError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeArtifactOperationBody(builder: DescribeArtifactResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARTIFACTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArtifactArn"))
    val ARTIFACTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArtifactName"))
    val ARTIFACTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArtifactType"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LINEAGEGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LineageGroupArn"))
    val METADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetadataProperties"))
    val PROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Properties"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Source"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACTARN_DESCRIPTOR)
        field(ARTIFACTNAME_DESCRIPTOR)
        field(ARTIFACTTYPE_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LINEAGEGROUPARN_DESCRIPTOR)
        field(METADATAPROPERTIES_DESCRIPTOR)
        field(PROPERTIES_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARTIFACTARN_DESCRIPTOR.index -> builder.artifactArn = deserializeString()
                ARTIFACTNAME_DESCRIPTOR.index -> builder.artifactName = deserializeString()
                ARTIFACTTYPE_DESCRIPTOR.index -> builder.artifactType = deserializeString()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LINEAGEGROUPARN_DESCRIPTOR.index -> builder.lineageGroupArn = deserializeString()
                METADATAPROPERTIES_DESCRIPTOR.index -> builder.metadataProperties = deserializeMetadataPropertiesDocument(deserializer)
                PROPERTIES_DESCRIPTOR.index -> builder.properties =
                    deserializer.deserializeMap(PROPERTIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeArtifactSourceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
