// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DataQualityAppSpecification
import aws.sdk.kotlin.services.sagemaker.model.DataQualityBaselineConfig
import aws.sdk.kotlin.services.sagemaker.model.DataQualityJobInput
import aws.sdk.kotlin.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse
import aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringResources
import aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDataQualityJobDefinitionOperationDeserializer: HttpDeserialize<DescribeDataQualityJobDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDataQualityJobDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDataQualityJobDefinitionError(context, response)
        }
        val builder = DescribeDataQualityJobDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDataQualityJobDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDataQualityJobDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDataQualityJobDefinitionOperationBody(builder: DescribeDataQualityJobDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATAQUALITYAPPSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataQualityAppSpecification"))
    val DATAQUALITYBASELINECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataQualityBaselineConfig"))
    val DATAQUALITYJOBINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataQualityJobInput"))
    val DATAQUALITYJOBOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataQualityJobOutputConfig"))
    val JOBDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionArn"))
    val JOBDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDefinitionName"))
    val JOBRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobResources"))
    val NETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DATAQUALITYAPPSPECIFICATION_DESCRIPTOR)
        field(DATAQUALITYBASELINECONFIG_DESCRIPTOR)
        field(DATAQUALITYJOBINPUT_DESCRIPTOR)
        field(DATAQUALITYJOBOUTPUTCONFIG_DESCRIPTOR)
        field(JOBDEFINITIONARN_DESCRIPTOR)
        field(JOBDEFINITIONNAME_DESCRIPTOR)
        field(JOBRESOURCES_DESCRIPTOR)
        field(NETWORKCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATAQUALITYAPPSPECIFICATION_DESCRIPTOR.index -> builder.dataQualityAppSpecification = deserializeDataQualityAppSpecificationDocument(deserializer)
                DATAQUALITYBASELINECONFIG_DESCRIPTOR.index -> builder.dataQualityBaselineConfig = deserializeDataQualityBaselineConfigDocument(deserializer)
                DATAQUALITYJOBINPUT_DESCRIPTOR.index -> builder.dataQualityJobInput = deserializeDataQualityJobInputDocument(deserializer)
                DATAQUALITYJOBOUTPUTCONFIG_DESCRIPTOR.index -> builder.dataQualityJobOutputConfig = deserializeMonitoringOutputConfigDocument(deserializer)
                JOBDEFINITIONARN_DESCRIPTOR.index -> builder.jobDefinitionArn = deserializeString()
                JOBDEFINITIONNAME_DESCRIPTOR.index -> builder.jobDefinitionName = deserializeString()
                JOBRESOURCES_DESCRIPTOR.index -> builder.jobResources = deserializeMonitoringResourcesDocument(deserializer)
                NETWORKCONFIG_DESCRIPTOR.index -> builder.networkConfig = deserializeMonitoringNetworkConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeMonitoringStoppingConditionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
