// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DeploymentStageStatusSummary
import aws.sdk.kotlin.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse
import aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentModelConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeEdgeDeploymentPlanOperationDeserializer: HttpDeserialize<DescribeEdgeDeploymentPlanResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEdgeDeploymentPlanResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEdgeDeploymentPlanError(context, response)
        }
        val builder = DescribeEdgeDeploymentPlanResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEdgeDeploymentPlanOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEdgeDeploymentPlanError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEdgeDeploymentPlanOperationBody(builder: DescribeEdgeDeploymentPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEVICEFLEETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceFleetName"))
    val EDGEDEPLOYMENTFAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("EdgeDeploymentFailed"))
    val EDGEDEPLOYMENTPENDING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("EdgeDeploymentPending"))
    val EDGEDEPLOYMENTPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EdgeDeploymentPlanArn"))
    val EDGEDEPLOYMENTPLANNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EdgeDeploymentPlanName"))
    val EDGEDEPLOYMENTSUCCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("EdgeDeploymentSuccess"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ModelConfigs"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Stages"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DEVICEFLEETNAME_DESCRIPTOR)
        field(EDGEDEPLOYMENTFAILED_DESCRIPTOR)
        field(EDGEDEPLOYMENTPENDING_DESCRIPTOR)
        field(EDGEDEPLOYMENTPLANARN_DESCRIPTOR)
        field(EDGEDEPLOYMENTPLANNAME_DESCRIPTOR)
        field(EDGEDEPLOYMENTSUCCESS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELCONFIGS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STAGES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEVICEFLEETNAME_DESCRIPTOR.index -> builder.deviceFleetName = deserializeString()
                EDGEDEPLOYMENTFAILED_DESCRIPTOR.index -> builder.edgeDeploymentFailed = deserializeInt()
                EDGEDEPLOYMENTPENDING_DESCRIPTOR.index -> builder.edgeDeploymentPending = deserializeInt()
                EDGEDEPLOYMENTPLANARN_DESCRIPTOR.index -> builder.edgeDeploymentPlanArn = deserializeString()
                EDGEDEPLOYMENTPLANNAME_DESCRIPTOR.index -> builder.edgeDeploymentPlanName = deserializeString()
                EDGEDEPLOYMENTSUCCESS_DESCRIPTOR.index -> builder.edgeDeploymentSuccess = deserializeInt()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELCONFIGS_DESCRIPTOR.index -> builder.modelConfigs =
                    deserializer.deserializeList(MODELCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<EdgeDeploymentModelConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEdgeDeploymentModelConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STAGES_DESCRIPTOR.index -> builder.stages =
                    deserializer.deserializeList(STAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentStageStatusSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentStageStatusSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
