// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeEdgePackagingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.EdgePackagingJobStatus
import aws.sdk.kotlin.services.sagemaker.model.EdgePresetDeploymentOutput
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeEdgePackagingJobOperationDeserializer: HttpDeserialize<DescribeEdgePackagingJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEdgePackagingJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEdgePackagingJobError(context, response)
        }
        val builder = DescribeEdgePackagingJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEdgePackagingJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEdgePackagingJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEdgePackagingJobOperationBody(builder: DescribeEdgePackagingJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPILATIONJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CompilationJobName"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val EDGEPACKAGINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EdgePackagingJobArn"))
    val EDGEPACKAGINGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EdgePackagingJobName"))
    val EDGEPACKAGINGJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("EdgePackagingJobStatus"))
    val EDGEPACKAGINGJOBSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EdgePackagingJobStatusMessage"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELARTIFACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelArtifact"))
    val MODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelName"))
    val MODELSIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelSignature"))
    val MODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelVersion"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val PRESETDEPLOYMENTOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PresetDeploymentOutput"))
    val RESOURCEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceKey"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPILATIONJOBNAME_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(EDGEPACKAGINGJOBARN_DESCRIPTOR)
        field(EDGEPACKAGINGJOBNAME_DESCRIPTOR)
        field(EDGEPACKAGINGJOBSTATUS_DESCRIPTOR)
        field(EDGEPACKAGINGJOBSTATUSMESSAGE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELARTIFACT_DESCRIPTOR)
        field(MODELNAME_DESCRIPTOR)
        field(MODELSIGNATURE_DESCRIPTOR)
        field(MODELVERSION_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(PRESETDEPLOYMENTOUTPUT_DESCRIPTOR)
        field(RESOURCEKEY_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPILATIONJOBNAME_DESCRIPTOR.index -> builder.compilationJobName = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                EDGEPACKAGINGJOBARN_DESCRIPTOR.index -> builder.edgePackagingJobArn = deserializeString()
                EDGEPACKAGINGJOBNAME_DESCRIPTOR.index -> builder.edgePackagingJobName = deserializeString()
                EDGEPACKAGINGJOBSTATUS_DESCRIPTOR.index -> builder.edgePackagingJobStatus = deserializeString().let { EdgePackagingJobStatus.fromValue(it) }
                EDGEPACKAGINGJOBSTATUSMESSAGE_DESCRIPTOR.index -> builder.edgePackagingJobStatusMessage = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELARTIFACT_DESCRIPTOR.index -> builder.modelArtifact = deserializeString()
                MODELNAME_DESCRIPTOR.index -> builder.modelName = deserializeString()
                MODELSIGNATURE_DESCRIPTOR.index -> builder.modelSignature = deserializeString()
                MODELVERSION_DESCRIPTOR.index -> builder.modelVersion = deserializeString()
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeEdgeOutputConfigDocument(deserializer)
                PRESETDEPLOYMENTOUTPUT_DESCRIPTOR.index -> builder.presetDeploymentOutput = deserializeEdgePresetDeploymentOutputDocument(deserializer)
                RESOURCEKEY_DESCRIPTOR.index -> builder.resourceKey = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
