// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse
import aws.sdk.kotlin.services.sagemaker.model.EndpointPerformance
import aws.sdk.kotlin.services.sagemaker.model.InferenceRecommendation
import aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig
import aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStatus
import aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStoppingConditions
import aws.sdk.kotlin.services.sagemaker.model.RecommendationJobType
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeInferenceRecommendationsJobOperationDeserializer: HttpDeserialize<DescribeInferenceRecommendationsJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInferenceRecommendationsJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInferenceRecommendationsJobError(context, response)
        }
        val builder = DescribeInferenceRecommendationsJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInferenceRecommendationsJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeInferenceRecommendationsJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInferenceRecommendationsJobOperationBody(builder: DescribeInferenceRecommendationsJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionTime"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENDPOINTPERFORMANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EndpointPerformances"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val INFERENCERECOMMENDATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InferenceRecommendations"))
    val INPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputConfig"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobArn"))
    val JOBDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobDescription"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobName"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobType"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STOPPINGCONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingConditions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETIONTIME_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ENDPOINTPERFORMANCES_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(INFERENCERECOMMENDATIONS_DESCRIPTOR)
        field(INPUTCONFIG_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBDESCRIPTION_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPPINGCONDITIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETIONTIME_DESCRIPTOR.index -> builder.completionTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENDPOINTPERFORMANCES_DESCRIPTOR.index -> builder.endpointPerformances =
                    deserializer.deserializeList(ENDPOINTPERFORMANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<EndpointPerformance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEndpointPerformanceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                INFERENCERECOMMENDATIONS_DESCRIPTOR.index -> builder.inferenceRecommendations =
                    deserializer.deserializeList(INFERENCERECOMMENDATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<InferenceRecommendation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInferenceRecommendationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INPUTCONFIG_DESCRIPTOR.index -> builder.inputConfig = deserializeRecommendationJobInputConfigDocument(deserializer)
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBDESCRIPTION_DESCRIPTOR.index -> builder.jobDescription = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                JOBTYPE_DESCRIPTOR.index -> builder.jobType = deserializeString().let { RecommendationJobType.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RecommendationJobStatus.fromValue(it) }
                STOPPINGCONDITIONS_DESCRIPTOR.index -> builder.stoppingConditions = deserializeRecommendationJobStoppingConditionsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
