// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribeModelPackageGroupResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelPackageGroupStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeModelPackageGroupOperationDeserializer: HttpDeserialize<DescribeModelPackageGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeModelPackageGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeModelPackageGroupError(context, response)
        }
        val builder = DescribeModelPackageGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeModelPackageGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeModelPackageGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelPackageGroupOperationBody(builder: DescribeModelPackageGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val MODELPACKAGEGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageGroupArn"))
    val MODELPACKAGEGROUPDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageGroupDescription"))
    val MODELPACKAGEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelPackageGroupName"))
    val MODELPACKAGEGROUPSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ModelPackageGroupStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(MODELPACKAGEGROUPARN_DESCRIPTOR)
        field(MODELPACKAGEGROUPDESCRIPTION_DESCRIPTOR)
        field(MODELPACKAGEGROUPNAME_DESCRIPTOR)
        field(MODELPACKAGEGROUPSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELPACKAGEGROUPARN_DESCRIPTOR.index -> builder.modelPackageGroupArn = deserializeString()
                MODELPACKAGEGROUPDESCRIPTION_DESCRIPTOR.index -> builder.modelPackageGroupDescription = deserializeString()
                MODELPACKAGEGROUPNAME_DESCRIPTOR.index -> builder.modelPackageGroupName = deserializeString()
                MODELPACKAGEGROUPSTATUS_DESCRIPTOR.index -> builder.modelPackageGroupStatus = deserializeString().let { ModelPackageGroupStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
