// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.DescribePipelineExecutionResponse
import aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration
import aws.sdk.kotlin.services.sagemaker.model.PipelineExecutionStatus
import aws.sdk.kotlin.services.sagemaker.model.PipelineExperimentConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribePipelineExecutionOperationDeserializer: HttpDeserialize<DescribePipelineExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePipelineExecutionResponse {
        if (!response.status.isSuccess()) {
            throwDescribePipelineExecutionError(context, response)
        }
        val builder = DescribePipelineExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePipelineExecutionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribePipelineExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePipelineExecutionOperationBody(builder: DescribePipelineExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val PARALLELISMCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ParallelismConfiguration"))
    val PIPELINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineArn"))
    val PIPELINEEXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineExecutionArn"))
    val PIPELINEEXECUTIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineExecutionDescription"))
    val PIPELINEEXECUTIONDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PipelineExecutionDisplayName"))
    val PIPELINEEXECUTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PipelineExecutionStatus"))
    val PIPELINEEXPERIMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PipelineExperimentConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(PARALLELISMCONFIGURATION_DESCRIPTOR)
        field(PIPELINEARN_DESCRIPTOR)
        field(PIPELINEEXECUTIONARN_DESCRIPTOR)
        field(PIPELINEEXECUTIONDESCRIPTION_DESCRIPTOR)
        field(PIPELINEEXECUTIONDISPLAYNAME_DESCRIPTOR)
        field(PIPELINEEXECUTIONSTATUS_DESCRIPTOR)
        field(PIPELINEEXPERIMENTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                PARALLELISMCONFIGURATION_DESCRIPTOR.index -> builder.parallelismConfiguration = deserializeParallelismConfigurationDocument(deserializer)
                PIPELINEARN_DESCRIPTOR.index -> builder.pipelineArn = deserializeString()
                PIPELINEEXECUTIONARN_DESCRIPTOR.index -> builder.pipelineExecutionArn = deserializeString()
                PIPELINEEXECUTIONDESCRIPTION_DESCRIPTOR.index -> builder.pipelineExecutionDescription = deserializeString()
                PIPELINEEXECUTIONDISPLAYNAME_DESCRIPTOR.index -> builder.pipelineExecutionDisplayName = deserializeString()
                PIPELINEEXECUTIONSTATUS_DESCRIPTOR.index -> builder.pipelineExecutionStatus = deserializeString().let { PipelineExecutionStatus.fromValue(it) }
                PIPELINEEXPERIMENTCONFIG_DESCRIPTOR.index -> builder.pipelineExperimentConfig = deserializePipelineExperimentConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
