// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.AppSpecification
import aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig
import aws.sdk.kotlin.services.sagemaker.model.NetworkConfig
import aws.sdk.kotlin.services.sagemaker.model.ProcessingInput
import aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus
import aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.ProcessingResources
import aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeProcessingJobOperationDeserializer: HttpDeserialize<DescribeProcessingJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProcessingJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProcessingJobError(context, response)
        }
        val builder = DescribeProcessingJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProcessingJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProcessingJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProcessingJobOperationBody(builder: DescribeProcessingJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AppSpecification"))
    val AUTOMLJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoMLJobArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Environment"))
    val EXITMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExitMessage"))
    val EXPERIMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExperimentConfig"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MONITORINGSCHEDULEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitoringScheduleArn"))
    val NETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfig"))
    val PROCESSINGENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ProcessingEndTime"))
    val PROCESSINGINPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessingInputs"))
    val PROCESSINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProcessingJobArn"))
    val PROCESSINGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProcessingJobName"))
    val PROCESSINGJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ProcessingJobStatus"))
    val PROCESSINGOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProcessingOutputConfig"))
    val PROCESSINGRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProcessingResources"))
    val PROCESSINGSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ProcessingStartTime"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val TRAININGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingJobArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPSPECIFICATION_DESCRIPTOR)
        field(AUTOMLJOBARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EXITMESSAGE_DESCRIPTOR)
        field(EXPERIMENTCONFIG_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MONITORINGSCHEDULEARN_DESCRIPTOR)
        field(NETWORKCONFIG_DESCRIPTOR)
        field(PROCESSINGENDTIME_DESCRIPTOR)
        field(PROCESSINGINPUTS_DESCRIPTOR)
        field(PROCESSINGJOBARN_DESCRIPTOR)
        field(PROCESSINGJOBNAME_DESCRIPTOR)
        field(PROCESSINGJOBSTATUS_DESCRIPTOR)
        field(PROCESSINGOUTPUTCONFIG_DESCRIPTOR)
        field(PROCESSINGRESOURCES_DESCRIPTOR)
        field(PROCESSINGSTARTTIME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TRAININGJOBARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPSPECIFICATION_DESCRIPTOR.index -> builder.appSpecification = deserializeAppSpecificationDocument(deserializer)
                AUTOMLJOBARN_DESCRIPTOR.index -> builder.autoMlJobArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENVIRONMENT_DESCRIPTOR.index -> builder.environment =
                    deserializer.deserializeMap(ENVIRONMENT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                EXITMESSAGE_DESCRIPTOR.index -> builder.exitMessage = deserializeString()
                EXPERIMENTCONFIG_DESCRIPTOR.index -> builder.experimentConfig = deserializeExperimentConfigDocument(deserializer)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MONITORINGSCHEDULEARN_DESCRIPTOR.index -> builder.monitoringScheduleArn = deserializeString()
                NETWORKCONFIG_DESCRIPTOR.index -> builder.networkConfig = deserializeNetworkConfigDocument(deserializer)
                PROCESSINGENDTIME_DESCRIPTOR.index -> builder.processingEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                PROCESSINGINPUTS_DESCRIPTOR.index -> builder.processingInputs =
                    deserializer.deserializeList(PROCESSINGINPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProcessingInput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProcessingInputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROCESSINGJOBARN_DESCRIPTOR.index -> builder.processingJobArn = deserializeString()
                PROCESSINGJOBNAME_DESCRIPTOR.index -> builder.processingJobName = deserializeString()
                PROCESSINGJOBSTATUS_DESCRIPTOR.index -> builder.processingJobStatus = deserializeString().let { ProcessingJobStatus.fromValue(it) }
                PROCESSINGOUTPUTCONFIG_DESCRIPTOR.index -> builder.processingOutputConfig = deserializeProcessingOutputConfigDocument(deserializer)
                PROCESSINGRESOURCES_DESCRIPTOR.index -> builder.processingResources = deserializeProcessingResourcesDocument(deserializer)
                PROCESSINGSTARTTIME_DESCRIPTOR.index -> builder.processingStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeProcessingStoppingConditionDocument(deserializer)
                TRAININGJOBARN_DESCRIPTOR.index -> builder.trainingJobArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
