// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.GetSearchSuggestionsResponse
import aws.sdk.kotlin.services.sagemaker.model.PropertyNameSuggestion
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSearchSuggestionsOperationDeserializer: HttpDeserialize<GetSearchSuggestionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSearchSuggestionsResponse {
        if (!response.status.isSuccess()) {
            throwGetSearchSuggestionsError(context, response)
        }
        val builder = GetSearchSuggestionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSearchSuggestionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSearchSuggestionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSearchSuggestionsOperationBody(builder: GetSearchSuggestionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROPERTYNAMESUGGESTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PropertyNameSuggestions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROPERTYNAMESUGGESTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROPERTYNAMESUGGESTIONS_DESCRIPTOR.index -> builder.propertyNameSuggestions =
                    deserializer.deserializeList(PROPERTYNAMESUGGESTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<PropertyNameSuggestion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePropertyNameSuggestionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
