// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.ImportHubContentResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportHubContentOperationDeserializer: HttpDeserialize<ImportHubContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ImportHubContentResponse {
        if (!response.status.isSuccess()) {
            throwImportHubContentError(context, response)
        }
        val builder = ImportHubContentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeImportHubContentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwImportHubContentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceInUse" -> ResourceInUseDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeImportHubContentOperationBody(builder: ImportHubContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HUBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubArn"))
    val HUBCONTENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HUBARN_DESCRIPTOR)
        field(HUBCONTENTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HUBARN_DESCRIPTOR.index -> builder.hubArn = deserializeString()
                HUBCONTENTARN_DESCRIPTOR.index -> builder.hubContentArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
