// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentPlanSummary
import aws.sdk.kotlin.services.sagemaker.model.ListEdgeDeploymentPlansResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListEdgeDeploymentPlansOperationDeserializer: HttpDeserialize<ListEdgeDeploymentPlansResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListEdgeDeploymentPlansResponse {
        if (!response.status.isSuccess()) {
            throwListEdgeDeploymentPlansError(context, response)
        }
        val builder = ListEdgeDeploymentPlansResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListEdgeDeploymentPlansOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListEdgeDeploymentPlansError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListEdgeDeploymentPlansOperationBody(builder: ListEdgeDeploymentPlansResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EDGEDEPLOYMENTPLANSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EdgeDeploymentPlanSummaries"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EDGEDEPLOYMENTPLANSUMMARIES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EDGEDEPLOYMENTPLANSUMMARIES_DESCRIPTOR.index -> builder.edgeDeploymentPlanSummaries =
                    deserializer.deserializeList(EDGEDEPLOYMENTPLANSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<EdgeDeploymentPlanSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEdgeDeploymentPlanSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
