// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UpdateInferenceExperimentResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateInferenceExperimentOperationDeserializer: HttpDeserialize<UpdateInferenceExperimentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateInferenceExperimentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateInferenceExperimentError(context, response)
        }
        val builder = UpdateInferenceExperimentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateInferenceExperimentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateInferenceExperimentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateInferenceExperimentOperationBody(builder: UpdateInferenceExperimentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INFERENCEEXPERIMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InferenceExperimentArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INFERENCEEXPERIMENTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INFERENCEEXPERIMENTARN_DESCRIPTOR.index -> builder.inferenceExperimentArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
