// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.waiters

import aws.sdk.kotlin.services.sagemaker.SageMakerClient
import aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeEndpointResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeProcessingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse
import aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun SageMakerClient.waitUntilEndpointDeleted(request: DescribeEndpointRequest): Outcome<DescribeEndpointResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEndpointRequest, DescribeEndpointResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ValidationException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val endpointStatus = it?.endpointStatus
            endpointStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEndpoint(request) }
}

public suspend fun SageMakerClient.waitUntilEndpointDeleted(block: DescribeEndpointRequest.Builder.() -> Unit): Outcome<DescribeEndpointResponse> =
    waitUntilEndpointDeleted(DescribeEndpointRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilEndpointInService(request: DescribeEndpointRequest): Outcome<DescribeEndpointResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEndpointRequest, DescribeEndpointResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val endpointStatus = it?.endpointStatus
            endpointStatus?.toString() == "InService"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val endpointStatus = it?.endpointStatus
            endpointStatus?.toString() == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEndpoint(request) }
}

public suspend fun SageMakerClient.waitUntilEndpointInService(block: DescribeEndpointRequest.Builder.() -> Unit): Outcome<DescribeEndpointResponse> =
    waitUntilEndpointInService(DescribeEndpointRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageCreated(request: DescribeImageRequest): Outcome<DescribeImageResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImageRequest, DescribeImageResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageStatus = it?.imageStatus
            imageStatus?.toString() == "CREATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageStatus = it?.imageStatus
            imageStatus?.toString() == "CREATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImage(request) }
}

public suspend fun SageMakerClient.waitUntilImageCreated(block: DescribeImageRequest.Builder.() -> Unit): Outcome<DescribeImageResponse> =
    waitUntilImageCreated(DescribeImageRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageDeleted(request: DescribeImageRequest): Outcome<DescribeImageResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImageRequest, DescribeImageResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageStatus = it?.imageStatus
            imageStatus?.toString() == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImage(request) }
}

public suspend fun SageMakerClient.waitUntilImageDeleted(block: DescribeImageRequest.Builder.() -> Unit): Outcome<DescribeImageResponse> =
    waitUntilImageDeleted(DescribeImageRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageUpdated(request: DescribeImageRequest): Outcome<DescribeImageResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImageRequest, DescribeImageResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageStatus = it?.imageStatus
            imageStatus?.toString() == "CREATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageStatus = it?.imageStatus
            imageStatus?.toString() == "UPDATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImage(request) }
}

public suspend fun SageMakerClient.waitUntilImageUpdated(block: DescribeImageRequest.Builder.() -> Unit): Outcome<DescribeImageResponse> =
    waitUntilImageUpdated(DescribeImageRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageVersionCreated(request: DescribeImageVersionRequest): Outcome<DescribeImageVersionResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImageVersionRequest, DescribeImageVersionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageVersionStatus = it?.imageVersionStatus
            imageVersionStatus?.toString() == "CREATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageVersionStatus = it?.imageVersionStatus
            imageVersionStatus?.toString() == "CREATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImageVersion(request) }
}

public suspend fun SageMakerClient.waitUntilImageVersionCreated(block: DescribeImageVersionRequest.Builder.() -> Unit): Outcome<DescribeImageVersionResponse> =
    waitUntilImageVersionCreated(DescribeImageVersionRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilImageVersionDeleted(request: DescribeImageVersionRequest): Outcome<DescribeImageVersionResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImageVersionRequest, DescribeImageVersionResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageVersionStatus = it?.imageVersionStatus
            imageVersionStatus?.toString() == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImageVersion(request) }
}

public suspend fun SageMakerClient.waitUntilImageVersionDeleted(block: DescribeImageVersionRequest.Builder.() -> Unit): Outcome<DescribeImageVersionResponse> =
    waitUntilImageVersionDeleted(DescribeImageVersionRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilNotebookInstanceDeleted(request: DescribeNotebookInstanceRequest): Outcome<DescribeNotebookInstanceResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ValidationException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val notebookInstanceStatus = it?.notebookInstanceStatus
            notebookInstanceStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNotebookInstance(request) }
}

public suspend fun SageMakerClient.waitUntilNotebookInstanceDeleted(block: DescribeNotebookInstanceRequest.Builder.() -> Unit): Outcome<DescribeNotebookInstanceResponse> =
    waitUntilNotebookInstanceDeleted(DescribeNotebookInstanceRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilNotebookInstanceInService(request: DescribeNotebookInstanceRequest): Outcome<DescribeNotebookInstanceResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val notebookInstanceStatus = it?.notebookInstanceStatus
            notebookInstanceStatus?.toString() == "InService"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val notebookInstanceStatus = it?.notebookInstanceStatus
            notebookInstanceStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNotebookInstance(request) }
}

public suspend fun SageMakerClient.waitUntilNotebookInstanceInService(block: DescribeNotebookInstanceRequest.Builder.() -> Unit): Outcome<DescribeNotebookInstanceResponse> =
    waitUntilNotebookInstanceInService(DescribeNotebookInstanceRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilNotebookInstanceStopped(request: DescribeNotebookInstanceRequest): Outcome<DescribeNotebookInstanceResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val notebookInstanceStatus = it?.notebookInstanceStatus
            notebookInstanceStatus?.toString() == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val notebookInstanceStatus = it?.notebookInstanceStatus
            notebookInstanceStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNotebookInstance(request) }
}

public suspend fun SageMakerClient.waitUntilNotebookInstanceStopped(block: DescribeNotebookInstanceRequest.Builder.() -> Unit): Outcome<DescribeNotebookInstanceResponse> =
    waitUntilNotebookInstanceStopped(DescribeNotebookInstanceRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilProcessingJobCompletedOrStopped(request: DescribeProcessingJobRequest): Outcome<DescribeProcessingJobResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeProcessingJobRequest, DescribeProcessingJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val processingJobStatus = it?.processingJobStatus
            processingJobStatus?.toString() == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val processingJobStatus = it?.processingJobStatus
            processingJobStatus?.toString() == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val processingJobStatus = it?.processingJobStatus
            processingJobStatus?.toString() == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeProcessingJob(request) }
}

public suspend fun SageMakerClient.waitUntilProcessingJobCompletedOrStopped(block: DescribeProcessingJobRequest.Builder.() -> Unit): Outcome<DescribeProcessingJobResponse> =
    waitUntilProcessingJobCompletedOrStopped(DescribeProcessingJobRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilTrainingJobCompletedOrStopped(request: DescribeTrainingJobRequest): Outcome<DescribeTrainingJobResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 120_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeTrainingJobRequest, DescribeTrainingJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val trainingJobStatus = it?.trainingJobStatus
            trainingJobStatus?.toString() == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val trainingJobStatus = it?.trainingJobStatus
            trainingJobStatus?.toString() == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val trainingJobStatus = it?.trainingJobStatus
            trainingJobStatus?.toString() == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTrainingJob(request) }
}

public suspend fun SageMakerClient.waitUntilTrainingJobCompletedOrStopped(block: DescribeTrainingJobRequest.Builder.() -> Unit): Outcome<DescribeTrainingJobResponse> =
    waitUntilTrainingJobCompletedOrStopped(DescribeTrainingJobRequest.Builder().apply(block).build())

public suspend fun SageMakerClient.waitUntilTransformJobCompletedOrStopped(request: DescribeTransformJobRequest): Outcome<DescribeTransformJobResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 60_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeTransformJobRequest, DescribeTransformJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val transformJobStatus = it?.transformJobStatus
            transformJobStatus?.toString() == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val transformJobStatus = it?.transformJobStatus
            transformJobStatus?.toString() == "Stopped"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val transformJobStatus = it?.transformJobStatus
            transformJobStatus?.toString() == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTransformJob(request) }
}

public suspend fun SageMakerClient.waitUntilTransformJobCompletedOrStopped(block: DescribeTransformJobRequest.Builder.() -> Unit): Outcome<DescribeTransformJobResponse> =
    waitUntilTransformJobCompletedOrStopped(DescribeTransformJobRequest.Builder().apply(block).build())
