// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.sagemakerruntime.model.*
import aws.sdk.kotlin.services.sagemakerruntime.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "SageMaker Runtime"
const val ServiceApiVersion: String = "2017-05-13"
const val SdkVersion: String = "0.14.2-beta"

internal class DefaultSageMakerRuntimeClient(override val config: SageMakerRuntimeClient.Config) : SageMakerRuntimeClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * After you deploy a model into production using Amazon SageMaker hosting services, your
     * client applications use this API to get inferences from the model hosted at the
     * specified endpoint.
     * For an overview of Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works.
     * Amazon SageMaker strips all POST headers except those supported by the API. Amazon SageMaker might add
     * additional headers. You should not rely on the behavior of headers outside those
     * enumerated in the request syntax.
     * Calls to InvokeEndpoint are authenticated by using Amazon Web Services Signature Version
     * 4. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating
     * Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
     * Reference.
     * A customer's model containers must respond to requests within 60 seconds. The model
     * itself can have a maximum processing time of 60 seconds before responding to
     * invocations. If your model is going to take 50-60 seconds of processing time, the SDK
     * socket timeout should be set to be 70 seconds.
     *
     * Endpoints are scoped to an individual account, and are not public. The URL does
     * not contain the account ID, but Amazon SageMaker determines the account ID from the
     * authentication token that is supplied by the caller.
     */
    override suspend fun invokeEndpoint(input: InvokeEndpointRequest): InvokeEndpointResponse {
        val op = SdkHttpOperation.build<InvokeEndpointRequest, InvokeEndpointResponse> {
            serializer = InvokeEndpointOperationSerializer()
            deserializer = InvokeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InvokeEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * After you deploy a model into production using Amazon SageMaker hosting services,
     * your client applications use this API to get inferences from the model hosted at
     * the specified endpoint in an asynchronous manner.
     *
     * Inference requests sent to this API are enqueued for asynchronous processing.
     * The processing of the inference request may or may not complete before the
     * you receive a response from this API. The response from this API will
     * not contain the result of the inference request but contain information
     * about where you can locate it.
     *
     * Amazon SageMaker strips all POST headers except those supported by the API.
     * Amazon SageMaker might add additional headers. You should not rely on the behavior
     * of headers outside those enumerated in the request syntax.
     *
     * Calls to InvokeEndpointAsync are authenticated by using Amazon Web Services Signature
     * Version 4. For information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
     * Reference.
     */
    override suspend fun invokeEndpointAsync(input: InvokeEndpointAsyncRequest): InvokeEndpointAsyncResponse {
        val op = SdkHttpOperation.build<InvokeEndpointAsyncRequest, InvokeEndpointAsyncResponse> {
            serializer = InvokeEndpointAsyncOperationSerializer()
            deserializer = InvokeEndpointAsyncOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "InvokeEndpointAsync"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "sagemaker"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AuthAttributes.SigningService, "sagemaker")
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AuthAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
