// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.sagemakerruntime.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.sagemakerruntime.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amazon SageMaker runtime API.
 */
interface SageMakerRuntimeClient : SdkClient {

    override val serviceName: String
        get() = "SageMaker Runtime"
    /**
     * SageMakerRuntimeClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): SageMakerRuntimeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSageMakerRuntimeClient(config)
        }

        operator fun invoke(config: Config): SageMakerRuntimeClient = DefaultSageMakerRuntimeClient(config)

        /**
         * Construct a [SageMakerRuntimeClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SageMakerRuntimeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultSageMakerRuntimeClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * After you deploy a model into production using Amazon SageMaker hosting services, your
     * client applications use this API to get inferences from the model hosted at the
     * specified endpoint.
     * For an overview of Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works.
     * Amazon SageMaker strips all POST headers except those supported by the API. Amazon SageMaker might add
     * additional headers. You should not rely on the behavior of headers outside those
     * enumerated in the request syntax.
     * Calls to InvokeEndpoint are authenticated by using Amazon Web Services Signature Version
     * 4. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating
     * Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
     * Reference.
     * A customer's model containers must respond to requests within 60 seconds. The model
     * itself can have a maximum processing time of 60 seconds before responding to
     * invocations. If your model is going to take 50-60 seconds of processing time, the SDK
     * socket timeout should be set to be 70 seconds.
     *
     * Endpoints are scoped to an individual account, and are not public. The URL does
     * not contain the account ID, but Amazon SageMaker determines the account ID from the
     * authentication token that is supplied by the caller.
     */
    suspend fun invokeEndpoint(input: InvokeEndpointRequest): InvokeEndpointResponse

    /**
     * After you deploy a model into production using Amazon SageMaker hosting services, your
     * client applications use this API to get inferences from the model hosted at the
     * specified endpoint.
     * For an overview of Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works.
     * Amazon SageMaker strips all POST headers except those supported by the API. Amazon SageMaker might add
     * additional headers. You should not rely on the behavior of headers outside those
     * enumerated in the request syntax.
     * Calls to InvokeEndpoint are authenticated by using Amazon Web Services Signature Version
     * 4. For information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating
     * Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
     * Reference.
     * A customer's model containers must respond to requests within 60 seconds. The model
     * itself can have a maximum processing time of 60 seconds before responding to
     * invocations. If your model is going to take 50-60 seconds of processing time, the SDK
     * socket timeout should be set to be 70 seconds.
     *
     * Endpoints are scoped to an individual account, and are not public. The URL does
     * not contain the account ID, but Amazon SageMaker determines the account ID from the
     * authentication token that is supplied by the caller.
     */
    suspend fun invokeEndpoint(block: InvokeEndpointRequest.Builder.() -> Unit) = invokeEndpoint(InvokeEndpointRequest.Builder().apply(block).build())

    /**
     * After you deploy a model into production using Amazon SageMaker hosting services,
     * your client applications use this API to get inferences from the model hosted at
     * the specified endpoint in an asynchronous manner.
     *
     * Inference requests sent to this API are enqueued for asynchronous processing.
     * The processing of the inference request may or may not complete before the
     * you receive a response from this API. The response from this API will
     * not contain the result of the inference request but contain information
     * about where you can locate it.
     *
     * Amazon SageMaker strips all POST headers except those supported by the API.
     * Amazon SageMaker might add additional headers. You should not rely on the behavior
     * of headers outside those enumerated in the request syntax.
     *
     * Calls to InvokeEndpointAsync are authenticated by using Amazon Web Services Signature
     * Version 4. For information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
     * Reference.
     */
    suspend fun invokeEndpointAsync(input: InvokeEndpointAsyncRequest): InvokeEndpointAsyncResponse

    /**
     * After you deploy a model into production using Amazon SageMaker hosting services,
     * your client applications use this API to get inferences from the model hosted at
     * the specified endpoint in an asynchronous manner.
     *
     * Inference requests sent to this API are enqueued for asynchronous processing.
     * The processing of the inference request may or may not complete before the
     * you receive a response from this API. The response from this API will
     * not contain the result of the inference request but contain information
     * about where you can locate it.
     *
     * Amazon SageMaker strips all POST headers except those supported by the API.
     * Amazon SageMaker might add additional headers. You should not rely on the behavior
     * of headers outside those enumerated in the request syntax.
     *
     * Calls to InvokeEndpointAsync are authenticated by using Amazon Web Services Signature
     * Version 4. For information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4) in the Amazon S3 API
     * Reference.
     */
    suspend fun invokeEndpointAsync(block: InvokeEndpointAsyncRequest.Builder.() -> Unit) = invokeEndpointAsync(InvokeEndpointAsyncRequest.Builder().apply(block).build())
}
