// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.model



class InvokeEndpointAsyncRequest private constructor(builder: Builder) {
    /**
     * The desired MIME type of the inference in the response.
     */
    val accept: kotlin.String? = builder.accept
    /**
     * The MIME type of the input data in the request body.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * Provides additional information about a request for an inference submitted to
     * a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is
     * forwarded verbatim. You could use this value, for example, to provide an ID that you
     * can use to track a request or to provide other metadata that a service endpoint was
     * programmed to process. The value must consist of no more than 1024
     * visible US-ASCII characters as specified in
     * <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6.
     * Field Value Components of the Hypertext Transfer Protocol (HTTP/1.1).
     *
     * The code in your model is responsible for setting or updating any custom attributes
     * in the response. If your code does not set this value in the response, an empty
     * value is returned. For example, if a custom attribute represents the trace ID,
     * your model can prepend the custom attribute with Trace ID: in your post-processing function.
     *
     * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
     */
    val customAttributes: kotlin.String? = builder.customAttributes
    /**
     * The name of the endpoint that you specified when you created the endpoint using
     * the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">
     * CreateEndpoint
     * API.
     */
    val endpointName: kotlin.String? = builder.endpointName
    /**
     * The identifier for the inference request. Amazon SageMaker will generate an identifier for you
     * if none is specified.
     */
    val inferenceId: kotlin.String? = builder.inferenceId
    /**
     * The Amazon S3 URI where the inference request payload is stored.
     */
    val inputLocation: kotlin.String? = builder.inputLocation
    /**
     * Maximum age in seconds a request can be in the queue before it is marked as expired.
     */
    val requestTtlSeconds: kotlin.Int? = builder.requestTtlSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeEndpointAsyncRequest(")
        append("accept=$accept,")
        append("contentType=$contentType,")
        append("customAttributes=*** Sensitive Data Redacted ***,")
        append("endpointName=$endpointName,")
        append("inferenceId=$inferenceId,")
        append("inputLocation=$inputLocation,")
        append("requestTtlSeconds=$requestTtlSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accept?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (customAttributes?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (inferenceId?.hashCode() ?: 0)
        result = 31 * result + (inputLocation?.hashCode() ?: 0)
        result = 31 * result + (requestTtlSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeEndpointAsyncRequest

        if (accept != other.accept) return false
        if (contentType != other.contentType) return false
        if (customAttributes != other.customAttributes) return false
        if (endpointName != other.endpointName) return false
        if (inferenceId != other.inferenceId) return false
        if (inputLocation != other.inputLocation) return false
        if (requestTtlSeconds != other.requestTtlSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The desired MIME type of the inference in the response.
         */
        var accept: kotlin.String? = null
        /**
         * The MIME type of the input data in the request body.
         */
        var contentType: kotlin.String? = null
        /**
         * Provides additional information about a request for an inference submitted to
         * a model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is
         * forwarded verbatim. You could use this value, for example, to provide an ID that you
         * can use to track a request or to provide other metadata that a service endpoint was
         * programmed to process. The value must consist of no more than 1024
         * visible US-ASCII characters as specified in
         * <a href="https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6">Section 3.3.6.
         * Field Value Components of the Hypertext Transfer Protocol (HTTP/1.1).
         *
         * The code in your model is responsible for setting or updating any custom attributes
         * in the response. If your code does not set this value in the response, an empty
         * value is returned. For example, if a custom attribute represents the trace ID,
         * your model can prepend the custom attribute with Trace ID: in your post-processing function.
         *
         * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
         */
        var customAttributes: kotlin.String? = null
        /**
         * The name of the endpoint that you specified when you created the endpoint using
         * the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">
         * CreateEndpoint
         * API.
         */
        var endpointName: kotlin.String? = null
        /**
         * The identifier for the inference request. Amazon SageMaker will generate an identifier for you
         * if none is specified.
         */
        var inferenceId: kotlin.String? = null
        /**
         * The Amazon S3 URI where the inference request payload is stored.
         */
        var inputLocation: kotlin.String? = null
        /**
         * Maximum age in seconds a request can be in the queue before it is marked as expired.
         */
        var requestTtlSeconds: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest) : this() {
            this.accept = x.accept
            this.contentType = x.contentType
            this.customAttributes = x.customAttributes
            this.endpointName = x.endpointName
            this.inferenceId = x.inferenceId
            this.inputLocation = x.inputLocation
            this.requestTtlSeconds = x.requestTtlSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncRequest = InvokeEndpointAsyncRequest(this)
    }
}
