// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.model



class InvokeEndpointResponse private constructor(builder: Builder) {
    /**
     * Includes the inference provided by the model.
     * For information about the format of the response body, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data
     * Formats-Inference.
     */
    val body: kotlin.ByteArray? = builder.body
    /**
     * The MIME type of the inference returned in the response body.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * Provides additional information in the response about the inference returned by a
     * model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is
     * forwarded verbatim. You could use this value, for example, to return an ID received in
     * the CustomAttributes header of a request or other metadata that a service
     * endpoint was programmed to produce. The value must consist of no more than 1024 visible
     * US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
     * Components of the Hypertext Transfer Protocol (HTTP/1.1). If the customer
     * wants the custom attribute returned, the model must set the custom attribute to be
     * included on the way back.
     * The code in your model is responsible for setting or updating any custom attributes in
     * the response. If your code does not set this value in the response, an empty value is
     * returned. For example, if a custom attribute represents the trace ID, your model can
     * prepend the custom attribute with Trace ID: in your post-processing
     * function.
     * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python
     * SDK.
     */
    val customAttributes: kotlin.String? = builder.customAttributes
    /**
     * Identifies the production variant that was invoked.
     */
    val invokedProductionVariant: kotlin.String? = builder.invokedProductionVariant

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeEndpointResponse(")
        append("body=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("customAttributes=*** Sensitive Data Redacted ***,")
        append("invokedProductionVariant=$invokedProductionVariant)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (customAttributes?.hashCode() ?: 0)
        result = 31 * result + (invokedProductionVariant?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeEndpointResponse

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (contentType != other.contentType) return false
        if (customAttributes != other.customAttributes) return false
        if (invokedProductionVariant != other.invokedProductionVariant) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Includes the inference provided by the model.
         * For information about the format of the response body, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data
         * Formats-Inference.
         */
        var body: kotlin.ByteArray? = null
        /**
         * The MIME type of the inference returned in the response body.
         */
        var contentType: kotlin.String? = null
        /**
         * Provides additional information in the response about the inference returned by a
         * model hosted at an Amazon SageMaker endpoint. The information is an opaque value that is
         * forwarded verbatim. You could use this value, for example, to return an ID received in
         * the CustomAttributes header of a request or other metadata that a service
         * endpoint was programmed to produce. The value must consist of no more than 1024 visible
         * US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
         * Components of the Hypertext Transfer Protocol (HTTP/1.1). If the customer
         * wants the custom attribute returned, the model must set the custom attribute to be
         * included on the way back.
         * The code in your model is responsible for setting or updating any custom attributes in
         * the response. If your code does not set this value in the response, an empty value is
         * returned. For example, if a custom attribute represents the trace ID, your model can
         * prepend the custom attribute with Trace ID: in your post-processing
         * function.
         * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python
         * SDK.
         */
        var customAttributes: kotlin.String? = null
        /**
         * Identifies the production variant that was invoked.
         */
        var invokedProductionVariant: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse) : this() {
            this.body = x.body
            this.contentType = x.contentType
            this.customAttributes = x.customAttributes
            this.invokedProductionVariant = x.invokedProductionVariant
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse = InvokeEndpointResponse(this)
    }
}
