// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointResponse
import aws.sdk.kotlin.services.sagemakerruntime.model.SageMakerRuntimeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class InvokeEndpointOperationDeserializer: HttpDeserialize<InvokeEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): InvokeEndpointResponse {
        if (!response.status.isSuccess()) {
            throwInvokeEndpointError(context, response)
        }
        val builder = InvokeEndpointResponse.Builder()

        builder.contentType = response.headers["Content-Type"]
        builder.customAttributes = response.headers["X-Amzn-SageMaker-Custom-Attributes"]
        builder.invokedProductionVariant = response.headers["x-Amzn-Invoked-Production-Variant"]

        builder.body = response.body.readAll()

        return builder.build()
    }
}

private suspend fun throwInvokeEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalDependencyException" -> InternalDependencyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedResponse)
        "ModelError" -> ModelErrorDeserializer().deserialize(context, wrappedResponse)
        "ModelNotReadyException" -> ModelNotReadyExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedResponse)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
