// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.transform

import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class InvokeEndpointOperationSerializer: HttpSerialize<InvokeEndpointRequest> {
    override suspend fun serialize(context: ExecutionContext, input: InvokeEndpointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "endpoints",
                "${input.endpointName}".encodeLabel(),
                "invocations",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.accept?.isNotEmpty() == true) append("Accept", input.accept)
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.customAttributes?.isNotEmpty() == true) append("X-Amzn-SageMaker-Custom-Attributes", input.customAttributes)
            if (input.inferenceId?.isNotEmpty() == true) append("X-Amzn-SageMaker-Inference-Id", input.inferenceId)
            if (input.targetContainerHostname?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Container-Hostname", input.targetContainerHostname)
            if (input.targetModel?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Model", input.targetModel)
            if (input.targetVariant?.isNotEmpty() == true) append("X-Amzn-SageMaker-Target-Variant", input.targetVariant)
        }

        if (input.body != null) {
            builder.body = ByteArrayContent(input.body)
        }
        builder.headers.setMissing("Content-Type", "application/octet-stream")
        return builder
    }
}
