// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemakerruntime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sagemakerruntime.model.InvokeEndpointAsyncResponse
import aws.sdk.kotlin.services.sagemakerruntime.model.SageMakerRuntimeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InvokeEndpointAsyncOperationDeserializer: HttpDeserialize<InvokeEndpointAsyncResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): InvokeEndpointAsyncResponse {
        if (!response.status.isSuccess()) {
            throwInvokeEndpointAsyncError(context, response)
        }
        val builder = InvokeEndpointAsyncResponse.Builder()

        builder.outputLocation = response.headers["X-Amzn-SageMaker-OutputLocation"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInvokeEndpointAsyncOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwInvokeEndpointAsyncError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailure" -> InternalFailureDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailable" -> ServiceUnavailableDeserializer().deserialize(context, wrappedResponse)
        "ValidationError" -> ValidationErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SageMakerRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInvokeEndpointAsyncOperationBody(builder: InvokeEndpointAsyncResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INFERENCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InferenceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INFERENCEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INFERENCEID_DESCRIPTOR.index -> builder.inferenceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
