// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.servicecatalog.model.*
import aws.sdk.kotlin.services.servicecatalog.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Service Catalog"
const val ServiceApiVersion: String = "2015-12-10"
const val SdkVersion: String = "0.16.5-beta"

internal class DefaultServiceCatalogClient(override val config: ServiceCatalogClient.Config) : ServiceCatalogClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts an offer to share the specified portfolio.
     */
    override suspend fun acceptPortfolioShare(input: AcceptPortfolioShareRequest): AcceptPortfolioShareResponse {
        val op = SdkHttpOperation.build<AcceptPortfolioShareRequest, AcceptPortfolioShareResponse> {
            serializer = AcceptPortfolioShareOperationSerializer()
            deserializer = AcceptPortfolioShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptPortfolioShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified budget with the specified resource.
     */
    override suspend fun associateBudgetWithResource(input: AssociateBudgetWithResourceRequest): AssociateBudgetWithResourceResponse {
        val op = SdkHttpOperation.build<AssociateBudgetWithResourceRequest, AssociateBudgetWithResourceResponse> {
            serializer = AssociateBudgetWithResourceOperationSerializer()
            deserializer = AssociateBudgetWithResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateBudgetWithResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified principal ARN with the specified portfolio.
     */
    override suspend fun associatePrincipalWithPortfolio(input: AssociatePrincipalWithPortfolioRequest): AssociatePrincipalWithPortfolioResponse {
        val op = SdkHttpOperation.build<AssociatePrincipalWithPortfolioRequest, AssociatePrincipalWithPortfolioResponse> {
            serializer = AssociatePrincipalWithPortfolioOperationSerializer()
            deserializer = AssociatePrincipalWithPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePrincipalWithPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified product with the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun associateProductWithPortfolio(input: AssociateProductWithPortfolioRequest): AssociateProductWithPortfolioResponse {
        val op = SdkHttpOperation.build<AssociateProductWithPortfolioRequest, AssociateProductWithPortfolioResponse> {
            serializer = AssociateProductWithPortfolioOperationSerializer()
            deserializer = AssociateProductWithPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateProductWithPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a self-service action with a provisioning artifact.
     */
    override suspend fun associateServiceActionWithProvisioningArtifact(input: AssociateServiceActionWithProvisioningArtifactRequest): AssociateServiceActionWithProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<AssociateServiceActionWithProvisioningArtifactRequest, AssociateServiceActionWithProvisioningArtifactResponse> {
            serializer = AssociateServiceActionWithProvisioningArtifactOperationSerializer()
            deserializer = AssociateServiceActionWithProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateServiceActionWithProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associate the specified TagOption with the specified portfolio or product.
     */
    override suspend fun associateTagOptionWithResource(input: AssociateTagOptionWithResourceRequest): AssociateTagOptionWithResourceResponse {
        val op = SdkHttpOperation.build<AssociateTagOptionWithResourceRequest, AssociateTagOptionWithResourceResponse> {
            serializer = AssociateTagOptionWithResourceOperationSerializer()
            deserializer = AssociateTagOptionWithResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTagOptionWithResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates multiple self-service actions with provisioning artifacts.
     */
    override suspend fun batchAssociateServiceActionWithProvisioningArtifact(input: BatchAssociateServiceActionWithProvisioningArtifactRequest): BatchAssociateServiceActionWithProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<BatchAssociateServiceActionWithProvisioningArtifactRequest, BatchAssociateServiceActionWithProvisioningArtifactResponse> {
            serializer = BatchAssociateServiceActionWithProvisioningArtifactOperationSerializer()
            deserializer = BatchAssociateServiceActionWithProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateServiceActionWithProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     */
    override suspend fun batchDisassociateServiceActionFromProvisioningArtifact(input: BatchDisassociateServiceActionFromProvisioningArtifactRequest): BatchDisassociateServiceActionFromProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<BatchDisassociateServiceActionFromProvisioningArtifactRequest, BatchDisassociateServiceActionFromProvisioningArtifactResponse> {
            serializer = BatchDisassociateServiceActionFromProvisioningArtifactOperationSerializer()
            deserializer = BatchDisassociateServiceActionFromProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateServiceActionFromProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified source product to the specified target product or a new product.
     *
     * You can copy a product to the same account or another account. You can copy a product to the same region or another region.
     *
     * This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.
     */
    override suspend fun copyProduct(input: CopyProductRequest): CopyProductResponse {
        val op = SdkHttpOperation.build<CopyProductRequest, CopyProductResponse> {
            serializer = CopyProductOperationSerializer()
            deserializer = CopyProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun createConstraint(input: CreateConstraintRequest): CreateConstraintResponse {
        val op = SdkHttpOperation.build<CreateConstraintRequest, CreateConstraintResponse> {
            serializer = CreateConstraintOperationSerializer()
            deserializer = CreateConstraintOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConstraint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun createPortfolio(input: CreatePortfolioRequest): CreatePortfolioResponse {
        val op = SdkHttpOperation.build<CreatePortfolioRequest, CreatePortfolioResponse> {
            serializer = CreatePortfolioOperationSerializer()
            deserializer = CreatePortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
     *
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     *
     * `AWSOrganizationsAccess` must be enabled in order to create a portfolio share to an organization node.
     *
     * You can't share a shared resource, including portfolios that contain a shared product.
     *
     * If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the ` UpdatePortfolioShare` API instead.
     */
    override suspend fun createPortfolioShare(input: CreatePortfolioShareRequest): CreatePortfolioShareResponse {
        val op = SdkHttpOperation.build<CreatePortfolioShareRequest, CreatePortfolioShareResponse> {
            serializer = CreatePortfolioShareOperationSerializer()
            deserializer = CreatePortfolioShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePortfolioShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a product.
     *
     * A delegated admin is authorized to invoke this command.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    override suspend fun createProduct(input: CreateProductRequest): CreateProductResponse {
        val op = SdkHttpOperation.build<CreateProductRequest, CreateProductResponse> {
            serializer = CreateProductOperationSerializer()
            deserializer = CreateProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a plan. A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.
     *
     * You can create one plan per provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILBLE or TAINTED.
     *
     * To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.
     */
    override suspend fun createProvisionedProductPlan(input: CreateProvisionedProductPlanRequest): CreateProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<CreateProvisionedProductPlanRequest, CreateProvisionedProductPlanResponse> {
            serializer = CreateProvisionedProductPlanOperationSerializer()
            deserializer = CreateProvisionedProductPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProvisionedProductPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot create a provisioning artifact for a product that was shared with you.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    override suspend fun createProvisioningArtifact(input: CreateProvisioningArtifactRequest): CreateProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<CreateProvisioningArtifactRequest, CreateProvisioningArtifactResponse> {
            serializer = CreateProvisioningArtifactOperationSerializer()
            deserializer = CreateProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a self-service action.
     */
    override suspend fun createServiceAction(input: CreateServiceActionRequest): CreateServiceActionResponse {
        val op = SdkHttpOperation.build<CreateServiceActionRequest, CreateServiceActionResponse> {
            serializer = CreateServiceActionOperationSerializer()
            deserializer = CreateServiceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateServiceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a TagOption.
     */
    override suspend fun createTagOption(input: CreateTagOptionRequest): CreateTagOptionResponse {
        val op = SdkHttpOperation.build<CreateTagOptionRequest, CreateTagOptionResponse> {
            serializer = CreateTagOptionOperationSerializer()
            deserializer = CreateTagOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTagOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun deleteConstraint(input: DeleteConstraintRequest): DeleteConstraintResponse {
        val op = SdkHttpOperation.build<DeleteConstraintRequest, DeleteConstraintResponse> {
            serializer = DeleteConstraintOperationSerializer()
            deserializer = DeleteConstraintOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConstraint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified portfolio.
     *
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun deletePortfolio(input: DeletePortfolioRequest): DeletePortfolioResponse {
        val op = SdkHttpOperation.build<DeletePortfolioRequest, DeletePortfolioResponse> {
            serializer = DeletePortfolioOperationSerializer()
            deserializer = DeletePortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
     *
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     */
    override suspend fun deletePortfolioShare(input: DeletePortfolioShareRequest): DeletePortfolioShareResponse {
        val op = SdkHttpOperation.build<DeletePortfolioShareRequest, DeletePortfolioShareResponse> {
            serializer = DeletePortfolioShareOperationSerializer()
            deserializer = DeletePortfolioShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePortfolioShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified product.
     *
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun deleteProduct(input: DeleteProductRequest): DeleteProductResponse {
        val op = SdkHttpOperation.build<DeleteProductRequest, DeleteProductResponse> {
            serializer = DeleteProductOperationSerializer()
            deserializer = DeleteProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified plan.
     */
    override suspend fun deleteProvisionedProductPlan(input: DeleteProvisionedProductPlanRequest): DeleteProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<DeleteProvisionedProductPlanRequest, DeleteProvisionedProductPlanResponse> {
            serializer = DeleteProvisionedProductPlanOperationSerializer()
            deserializer = DeleteProvisionedProductPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProvisionedProductPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     */
    override suspend fun deleteProvisioningArtifact(input: DeleteProvisioningArtifactRequest): DeleteProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<DeleteProvisioningArtifactRequest, DeleteProvisioningArtifactResponse> {
            serializer = DeleteProvisioningArtifactOperationSerializer()
            deserializer = DeleteProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a self-service action.
     */
    override suspend fun deleteServiceAction(input: DeleteServiceActionRequest): DeleteServiceActionResponse {
        val op = SdkHttpOperation.build<DeleteServiceActionRequest, DeleteServiceActionResponse> {
            serializer = DeleteServiceActionOperationSerializer()
            deserializer = DeleteServiceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteServiceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified TagOption.
     *
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     */
    override suspend fun deleteTagOption(input: DeleteTagOptionRequest): DeleteTagOptionResponse {
        val op = SdkHttpOperation.build<DeleteTagOptionRequest, DeleteTagOptionResponse> {
            serializer = DeleteTagOptionOperationSerializer()
            deserializer = DeleteTagOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTagOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified constraint.
     */
    override suspend fun describeConstraint(input: DescribeConstraintRequest): DescribeConstraintResponse {
        val op = SdkHttpOperation.build<DescribeConstraintRequest, DescribeConstraintResponse> {
            serializer = DescribeConstraintOperationSerializer()
            deserializer = DescribeConstraintOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConstraint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the specified copy product operation.
     */
    override suspend fun describeCopyProductStatus(input: DescribeCopyProductStatusRequest): DescribeCopyProductStatusResponse {
        val op = SdkHttpOperation.build<DescribeCopyProductStatusRequest, DescribeCopyProductStatusResponse> {
            serializer = DescribeCopyProductStatusOperationSerializer()
            deserializer = DescribeCopyProductStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCopyProductStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun describePortfolio(input: DescribePortfolioRequest): DescribePortfolioResponse {
        val op = SdkHttpOperation.build<DescribePortfolioRequest, DescribePortfolioResponse> {
            serializer = DescribePortfolioOperationSerializer()
            deserializer = DescribePortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
     */
    override suspend fun describePortfolioShareStatus(input: DescribePortfolioShareStatusRequest): DescribePortfolioShareStatusResponse {
        val op = SdkHttpOperation.build<DescribePortfolioShareStatusRequest, DescribePortfolioShareStatusResponse> {
            serializer = DescribePortfolioShareStatusOperationSerializer()
            deserializer = DescribePortfolioShareStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePortfolioShareStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     *
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.
     *
     * The `PortfolioId` and `Type` parameters are both required.
     */
    override suspend fun describePortfolioShares(input: DescribePortfolioSharesRequest): DescribePortfolioSharesResponse {
        val op = SdkHttpOperation.build<DescribePortfolioSharesRequest, DescribePortfolioSharesResponse> {
            serializer = DescribePortfolioSharesOperationSerializer()
            deserializer = DescribePortfolioSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePortfolioShares"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified product.
     */
    override suspend fun describeProduct(input: DescribeProductRequest): DescribeProductResponse {
        val op = SdkHttpOperation.build<DescribeProductRequest, DescribeProductResponse> {
            serializer = DescribeProductOperationSerializer()
            deserializer = DescribeProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified product. This operation is run with administrator access.
     */
    override suspend fun describeProductAsAdmin(input: DescribeProductAsAdminRequest): DescribeProductAsAdminResponse {
        val op = SdkHttpOperation.build<DescribeProductAsAdminRequest, DescribeProductAsAdminResponse> {
            serializer = DescribeProductAsAdminOperationSerializer()
            deserializer = DescribeProductAsAdminOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProductAsAdmin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified product.
     */
    override suspend fun describeProductView(input: DescribeProductViewRequest): DescribeProductViewResponse {
        val op = SdkHttpOperation.build<DescribeProductViewRequest, DescribeProductViewResponse> {
            serializer = DescribeProductViewOperationSerializer()
            deserializer = DescribeProductViewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProductView"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified provisioned product.
     */
    override suspend fun describeProvisionedProduct(input: DescribeProvisionedProductRequest): DescribeProvisionedProductResponse {
        val op = SdkHttpOperation.build<DescribeProvisionedProductRequest, DescribeProvisionedProductResponse> {
            serializer = DescribeProvisionedProductOperationSerializer()
            deserializer = DescribeProvisionedProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProvisionedProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the resource changes for the specified plan.
     */
    override suspend fun describeProvisionedProductPlan(input: DescribeProvisionedProductPlanRequest): DescribeProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<DescribeProvisionedProductPlanRequest, DescribeProvisionedProductPlanResponse> {
            serializer = DescribeProvisionedProductPlanOperationSerializer()
            deserializer = DescribeProvisionedProductPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProvisionedProductPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     */
    override suspend fun describeProvisioningArtifact(input: DescribeProvisioningArtifactRequest): DescribeProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<DescribeProvisioningArtifactRequest, DescribeProvisioningArtifactResponse> {
            serializer = DescribeProvisioningArtifactOperationSerializer()
            deserializer = DescribeProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
     *
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*". Tag the provisioned product with the value `sc-tagoption-conflict-portfolioId-productId`.
     */
    override suspend fun describeProvisioningParameters(input: DescribeProvisioningParametersRequest): DescribeProvisioningParametersResponse {
        val op = SdkHttpOperation.build<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResponse> {
            serializer = DescribeProvisioningParametersOperationSerializer()
            deserializer = DescribeProvisioningParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProvisioningParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified request operation.
     *
     * Use this operation after calling a request operation (for example, ProvisionProduct, TerminateProvisionedProduct, or UpdateProvisionedProduct).
     *
     * If a provisioned product was transferred to a new owner using UpdateProvisionedProductProperties, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use ListRecordHistory to see the product's history from when he was the owner.
     */
    override suspend fun describeRecord(input: DescribeRecordRequest): DescribeRecordResponse {
        val op = SdkHttpOperation.build<DescribeRecordRequest, DescribeRecordResponse> {
            serializer = DescribeRecordOperationSerializer()
            deserializer = DescribeRecordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRecord"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a self-service action.
     */
    override suspend fun describeServiceAction(input: DescribeServiceActionRequest): DescribeServiceActionResponse {
        val op = SdkHttpOperation.build<DescribeServiceActionRequest, DescribeServiceActionResponse> {
            serializer = DescribeServiceActionOperationSerializer()
            deserializer = DescribeServiceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServiceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
     */
    override suspend fun describeServiceActionExecutionParameters(input: DescribeServiceActionExecutionParametersRequest): DescribeServiceActionExecutionParametersResponse {
        val op = SdkHttpOperation.build<DescribeServiceActionExecutionParametersRequest, DescribeServiceActionExecutionParametersResponse> {
            serializer = DescribeServiceActionExecutionParametersOperationSerializer()
            deserializer = DescribeServiceActionExecutionParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServiceActionExecutionParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified TagOption.
     */
    override suspend fun describeTagOption(input: DescribeTagOptionRequest): DescribeTagOptionResponse {
        val op = SdkHttpOperation.build<DescribeTagOptionRequest, DescribeTagOptionResponse> {
            serializer = DescribeTagOptionOperationSerializer()
            deserializer = DescribeTagOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTagOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disable portfolio sharing through AWS Organizations feature. This feature will not delete your current shares but it will prevent you from creating new shares throughout your organization. Current shares will not be in sync with your organization structure if it changes after calling this API. This API can only be called by the management account in the organization.
     *
     * This API can't be invoked if there are active delegated administrators in the organization.
     *
     * Note that a delegated administrator is not authorized to invoke `DisableAWSOrganizationsAccess`.
     */
    override suspend fun disableAwsOrganizationsAccess(input: DisableAwsOrganizationsAccessRequest): DisableAwsOrganizationsAccessResponse {
        val op = SdkHttpOperation.build<DisableAwsOrganizationsAccessRequest, DisableAwsOrganizationsAccessResponse> {
            serializer = DisableAWSOrganizationsAccessOperationSerializer()
            deserializer = DisableAWSOrganizationsAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableAWSOrganizationsAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified budget from the specified resource.
     */
    override suspend fun disassociateBudgetFromResource(input: DisassociateBudgetFromResourceRequest): DisassociateBudgetFromResourceResponse {
        val op = SdkHttpOperation.build<DisassociateBudgetFromResourceRequest, DisassociateBudgetFromResourceResponse> {
            serializer = DisassociateBudgetFromResourceOperationSerializer()
            deserializer = DisassociateBudgetFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateBudgetFromResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a previously associated principal ARN from a specified portfolio.
     */
    override suspend fun disassociatePrincipalFromPortfolio(input: DisassociatePrincipalFromPortfolioRequest): DisassociatePrincipalFromPortfolioResponse {
        val op = SdkHttpOperation.build<DisassociatePrincipalFromPortfolioRequest, DisassociatePrincipalFromPortfolioResponse> {
            serializer = DisassociatePrincipalFromPortfolioOperationSerializer()
            deserializer = DisassociatePrincipalFromPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociatePrincipalFromPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified product from the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun disassociateProductFromPortfolio(input: DisassociateProductFromPortfolioRequest): DisassociateProductFromPortfolioResponse {
        val op = SdkHttpOperation.build<DisassociateProductFromPortfolioRequest, DisassociateProductFromPortfolioResponse> {
            serializer = DisassociateProductFromPortfolioOperationSerializer()
            deserializer = DisassociateProductFromPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateProductFromPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     */
    override suspend fun disassociateServiceActionFromProvisioningArtifact(input: DisassociateServiceActionFromProvisioningArtifactRequest): DisassociateServiceActionFromProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<DisassociateServiceActionFromProvisioningArtifactRequest, DisassociateServiceActionFromProvisioningArtifactResponse> {
            serializer = DisassociateServiceActionFromProvisioningArtifactOperationSerializer()
            deserializer = DisassociateServiceActionFromProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateServiceActionFromProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified TagOption from the specified resource.
     */
    override suspend fun disassociateTagOptionFromResource(input: DisassociateTagOptionFromResourceRequest): DisassociateTagOptionFromResourceResponse {
        val op = SdkHttpOperation.build<DisassociateTagOptionFromResourceRequest, DisassociateTagOptionFromResourceResponse> {
            serializer = DisassociateTagOptionFromResourceOperationSerializer()
            deserializer = DisassociateTagOptionFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTagOptionFromResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable portfolio sharing feature through AWS Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
     *
     * By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure.
     *
     * Note that a delegated administrator is not authorized to invoke `EnableAWSOrganizationsAccess`.
     */
    override suspend fun enableAwsOrganizationsAccess(input: EnableAwsOrganizationsAccessRequest): EnableAwsOrganizationsAccessResponse {
        val op = SdkHttpOperation.build<EnableAwsOrganizationsAccessRequest, EnableAwsOrganizationsAccessResponse> {
            serializer = EnableAWSOrganizationsAccessOperationSerializer()
            deserializer = EnableAWSOrganizationsAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableAWSOrganizationsAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions or modifies a product based on the resource changes for the specified plan.
     */
    override suspend fun executeProvisionedProductPlan(input: ExecuteProvisionedProductPlanRequest): ExecuteProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<ExecuteProvisionedProductPlanRequest, ExecuteProvisionedProductPlanResponse> {
            serializer = ExecuteProvisionedProductPlanOperationSerializer()
            deserializer = ExecuteProvisionedProductPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteProvisionedProductPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Executes a self-service action against a provisioned product.
     */
    override suspend fun executeProvisionedProductServiceAction(input: ExecuteProvisionedProductServiceActionRequest): ExecuteProvisionedProductServiceActionResponse {
        val op = SdkHttpOperation.build<ExecuteProvisionedProductServiceActionRequest, ExecuteProvisionedProductServiceActionResponse> {
            serializer = ExecuteProvisionedProductServiceActionOperationSerializer()
            deserializer = ExecuteProvisionedProductServiceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteProvisionedProductServiceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the Access Status for AWS Organization portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
     */
    override suspend fun getAwsOrganizationsAccessStatus(input: GetAwsOrganizationsAccessStatusRequest): GetAwsOrganizationsAccessStatusResponse {
        val op = SdkHttpOperation.build<GetAwsOrganizationsAccessStatusRequest, GetAwsOrganizationsAccessStatusResponse> {
            serializer = GetAWSOrganizationsAccessStatusOperationSerializer()
            deserializer = GetAWSOrganizationsAccessStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAWSOrganizationsAccessStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
     */
    override suspend fun getProvisionedProductOutputs(input: GetProvisionedProductOutputsRequest): GetProvisionedProductOutputsResponse {
        val op = SdkHttpOperation.build<GetProvisionedProductOutputsRequest, GetProvisionedProductOutputsResponse> {
            serializer = GetProvisionedProductOutputsOperationSerializer()
            deserializer = GetProvisionedProductOutputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProvisionedProductOutputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are supported on the provisioned product.
     *
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and non-root nested stacks are not supported.
     *
     * The CloudFormation stack must have one of the following statuses to be imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`, `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`, `IMPORT_ROLLBACK_COMPLETE`.
     *
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM policy permissions.
     */
    override suspend fun importAsProvisionedProduct(input: ImportAsProvisionedProductRequest): ImportAsProvisionedProductResponse {
        val op = SdkHttpOperation.build<ImportAsProvisionedProductRequest, ImportAsProvisionedProductResponse> {
            serializer = ImportAsProvisionedProductOperationSerializer()
            deserializer = ImportAsProvisionedProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportAsProvisionedProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
     */
    override suspend fun listAcceptedPortfolioShares(input: ListAcceptedPortfolioSharesRequest): ListAcceptedPortfolioSharesResponse {
        val op = SdkHttpOperation.build<ListAcceptedPortfolioSharesRequest, ListAcceptedPortfolioSharesResponse> {
            serializer = ListAcceptedPortfolioSharesOperationSerializer()
            deserializer = ListAcceptedPortfolioSharesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAcceptedPortfolioShares"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the budgets associated to the specified resource.
     */
    override suspend fun listBudgetsForResource(input: ListBudgetsForResourceRequest): ListBudgetsForResourceResponse {
        val op = SdkHttpOperation.build<ListBudgetsForResourceRequest, ListBudgetsForResourceResponse> {
            serializer = ListBudgetsForResourceOperationSerializer()
            deserializer = ListBudgetsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBudgetsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the constraints for the specified portfolio and product.
     */
    override suspend fun listConstraintsForPortfolio(input: ListConstraintsForPortfolioRequest): ListConstraintsForPortfolioResponse {
        val op = SdkHttpOperation.build<ListConstraintsForPortfolioRequest, ListConstraintsForPortfolioResponse> {
            serializer = ListConstraintsForPortfolioOperationSerializer()
            deserializer = ListConstraintsForPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConstraintsForPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the paths to the specified product. A path is how the user has access to a specified product, and is necessary when provisioning a product. A path also determines the constraints put on the product.
     */
    override suspend fun listLaunchPaths(input: ListLaunchPathsRequest): ListLaunchPathsResponse {
        val op = SdkHttpOperation.build<ListLaunchPathsRequest, ListLaunchPathsResponse> {
            serializer = ListLaunchPathsOperationSerializer()
            deserializer = ListLaunchPathsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLaunchPaths"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
     *
     * If a delegated admin is de-registered, they can no longer perform this operation.
     */
    override suspend fun listOrganizationPortfolioAccess(input: ListOrganizationPortfolioAccessRequest): ListOrganizationPortfolioAccessResponse {
        val op = SdkHttpOperation.build<ListOrganizationPortfolioAccessRequest, ListOrganizationPortfolioAccessResponse> {
            serializer = ListOrganizationPortfolioAccessOperationSerializer()
            deserializer = ListOrganizationPortfolioAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizationPortfolioAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the account IDs that have access to the specified portfolio.
     *
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.
     */
    override suspend fun listPortfolioAccess(input: ListPortfolioAccessRequest): ListPortfolioAccessResponse {
        val op = SdkHttpOperation.build<ListPortfolioAccessRequest, ListPortfolioAccessResponse> {
            serializer = ListPortfolioAccessOperationSerializer()
            deserializer = ListPortfolioAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPortfolioAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all portfolios in the catalog.
     */
    override suspend fun listPortfolios(input: ListPortfoliosRequest): ListPortfoliosResponse {
        val op = SdkHttpOperation.build<ListPortfoliosRequest, ListPortfoliosResponse> {
            serializer = ListPortfoliosOperationSerializer()
            deserializer = ListPortfoliosOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPortfolios"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all portfolios that the specified product is associated with.
     */
    override suspend fun listPortfoliosForProduct(input: ListPortfoliosForProductRequest): ListPortfoliosForProductResponse {
        val op = SdkHttpOperation.build<ListPortfoliosForProductRequest, ListPortfoliosForProductResponse> {
            serializer = ListPortfoliosForProductOperationSerializer()
            deserializer = ListPortfoliosForProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPortfoliosForProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all principal ARNs associated with the specified portfolio.
     */
    override suspend fun listPrincipalsForPortfolio(input: ListPrincipalsForPortfolioRequest): ListPrincipalsForPortfolioResponse {
        val op = SdkHttpOperation.build<ListPrincipalsForPortfolioRequest, ListPrincipalsForPortfolioResponse> {
            serializer = ListPrincipalsForPortfolioOperationSerializer()
            deserializer = ListPrincipalsForPortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPrincipalsForPortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     */
    override suspend fun listProvisionedProductPlans(input: ListProvisionedProductPlansRequest): ListProvisionedProductPlansResponse {
        val op = SdkHttpOperation.build<ListProvisionedProductPlansRequest, ListProvisionedProductPlansResponse> {
            serializer = ListProvisionedProductPlansOperationSerializer()
            deserializer = ListProvisionedProductPlansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProvisionedProductPlans"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     */
    override suspend fun listProvisioningArtifacts(input: ListProvisioningArtifactsRequest): ListProvisioningArtifactsResponse {
        val op = SdkHttpOperation.build<ListProvisioningArtifactsRequest, ListProvisioningArtifactsResponse> {
            serializer = ListProvisioningArtifactsOperationSerializer()
            deserializer = ListProvisioningArtifactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProvisioningArtifacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     */
    override suspend fun listProvisioningArtifactsForServiceAction(input: ListProvisioningArtifactsForServiceActionRequest): ListProvisioningArtifactsForServiceActionResponse {
        val op = SdkHttpOperation.build<ListProvisioningArtifactsForServiceActionRequest, ListProvisioningArtifactsForServiceActionResponse> {
            serializer = ListProvisioningArtifactsForServiceActionOperationSerializer()
            deserializer = ListProvisioningArtifactsForServiceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProvisioningArtifactsForServiceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the specified requests or all performed requests.
     */
    override suspend fun listRecordHistory(input: ListRecordHistoryRequest): ListRecordHistoryResponse {
        val op = SdkHttpOperation.build<ListRecordHistoryRequest, ListRecordHistoryResponse> {
            serializer = ListRecordHistoryOperationSerializer()
            deserializer = ListRecordHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecordHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resources associated with the specified TagOption.
     */
    override suspend fun listResourcesForTagOption(input: ListResourcesForTagOptionRequest): ListResourcesForTagOptionResponse {
        val op = SdkHttpOperation.build<ListResourcesForTagOptionRequest, ListResourcesForTagOptionResponse> {
            serializer = ListResourcesForTagOptionOperationSerializer()
            deserializer = ListResourcesForTagOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResourcesForTagOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all self-service actions.
     */
    override suspend fun listServiceActions(input: ListServiceActionsRequest): ListServiceActionsResponse {
        val op = SdkHttpOperation.build<ListServiceActionsRequest, ListServiceActionsResponse> {
            serializer = ListServiceActionsOperationSerializer()
            deserializer = ListServiceActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
     */
    override suspend fun listServiceActionsForProvisioningArtifact(input: ListServiceActionsForProvisioningArtifactRequest): ListServiceActionsForProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<ListServiceActionsForProvisioningArtifactRequest, ListServiceActionsForProvisioningArtifactResponse> {
            serializer = ListServiceActionsForProvisioningArtifactOperationSerializer()
            deserializer = ListServiceActionsForProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceActionsForProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific AWS account name or region.
     */
    override suspend fun listStackInstancesForProvisionedProduct(input: ListStackInstancesForProvisionedProductRequest): ListStackInstancesForProvisionedProductResponse {
        val op = SdkHttpOperation.build<ListStackInstancesForProvisionedProductRequest, ListStackInstancesForProvisionedProductResponse> {
            serializer = ListStackInstancesForProvisionedProductOperationSerializer()
            deserializer = ListStackInstancesForProvisionedProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStackInstancesForProvisionedProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the specified TagOptions or all TagOptions.
     */
    override suspend fun listTagOptions(input: ListTagOptionsRequest): ListTagOptionsResponse {
        val op = SdkHttpOperation.build<ListTagOptionsRequest, ListTagOptionsResponse> {
            serializer = ListTagOptionsOperationSerializer()
            deserializer = ListTagOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions the specified product.
     *
     * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord.
     *
     * If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not include conflicted keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*".
     */
    override suspend fun provisionProduct(input: ProvisionProductRequest): ProvisionProductResponse {
        val op = SdkHttpOperation.build<ProvisionProductRequest, ProvisionProductResponse> {
            serializer = ProvisionProductOperationSerializer()
            deserializer = ProvisionProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects an offer to share the specified portfolio.
     */
    override suspend fun rejectPortfolioShare(input: RejectPortfolioShareRequest): RejectPortfolioShareResponse {
        val op = SdkHttpOperation.build<RejectPortfolioShareRequest, RejectPortfolioShareResponse> {
            serializer = RejectPortfolioShareOperationSerializer()
            deserializer = RejectPortfolioShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectPortfolioShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the provisioned products that are available (not terminated).
     *
     * To use additional filtering, see SearchProvisionedProducts.
     */
    override suspend fun scanProvisionedProducts(input: ScanProvisionedProductsRequest): ScanProvisionedProductsResponse {
        val op = SdkHttpOperation.build<ScanProvisionedProductsRequest, ScanProvisionedProductsResponse> {
            serializer = ScanProvisionedProductsOperationSerializer()
            deserializer = ScanProvisionedProductsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ScanProvisionedProducts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the products to which the caller has access.
     */
    override suspend fun searchProducts(input: SearchProductsRequest): SearchProductsResponse {
        val op = SdkHttpOperation.build<SearchProductsRequest, SearchProductsResponse> {
            serializer = SearchProductsOperationSerializer()
            deserializer = SearchProductsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchProducts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the products for the specified portfolio or all products.
     */
    override suspend fun searchProductsAsAdmin(input: SearchProductsAsAdminRequest): SearchProductsAsAdminResponse {
        val op = SdkHttpOperation.build<SearchProductsAsAdminRequest, SearchProductsAsAdminResponse> {
            serializer = SearchProductsAsAdminOperationSerializer()
            deserializer = SearchProductsAsAdminOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchProductsAsAdmin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the provisioned products that meet the specified criteria.
     */
    override suspend fun searchProvisionedProducts(input: SearchProvisionedProductsRequest): SearchProvisionedProductsResponse {
        val op = SdkHttpOperation.build<SearchProvisionedProductsRequest, SearchProvisionedProductsResponse> {
            serializer = SearchProvisionedProductsOperationSerializer()
            deserializer = SearchProvisionedProductsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchProvisionedProducts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Terminates the specified provisioned product.
     *
     * This operation does not delete any records associated with the provisioned product.
     *
     * You can check the status of this request using DescribeRecord.
     */
    override suspend fun terminateProvisionedProduct(input: TerminateProvisionedProductRequest): TerminateProvisionedProductResponse {
        val op = SdkHttpOperation.build<TerminateProvisionedProductRequest, TerminateProvisionedProductResponse> {
            serializer = TerminateProvisionedProductOperationSerializer()
            deserializer = TerminateProvisionedProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TerminateProvisionedProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified constraint.
     */
    override suspend fun updateConstraint(input: UpdateConstraintRequest): UpdateConstraintResponse {
        val op = SdkHttpOperation.build<UpdateConstraintRequest, UpdateConstraintResponse> {
            serializer = UpdateConstraintOperationSerializer()
            deserializer = UpdateConstraintOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConstraint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified portfolio.
     *
     * You cannot update a product that was shared with you.
     */
    override suspend fun updatePortfolio(input: UpdatePortfolioRequest): UpdatePortfolioResponse {
        val op = SdkHttpOperation.build<UpdatePortfolioRequest, UpdatePortfolioResponse> {
            serializer = UpdatePortfolioOperationSerializer()
            deserializer = UpdatePortfolioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePortfolio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an existing portfolio share.
     *
     * The portfolio share cannot be updated if the ` CreatePortfolioShare` operation is `IN_PROGRESS`, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be COMPLETED.
     *
     * You must provide the `accountId` or organization node in the input, but not both.
     *
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke `UpdatePortfolioShare` separately for each share type.
     *
     * This API cannot be used for removing the portfolio share. You must use `DeletePortfolioShare` API for that action.
     */
    override suspend fun updatePortfolioShare(input: UpdatePortfolioShareRequest): UpdatePortfolioShareResponse {
        val op = SdkHttpOperation.build<UpdatePortfolioShareRequest, UpdatePortfolioShareResponse> {
            serializer = UpdatePortfolioShareOperationSerializer()
            deserializer = UpdatePortfolioShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePortfolioShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified product.
     */
    override suspend fun updateProduct(input: UpdateProductRequest): UpdateProductResponse {
        val op = SdkHttpOperation.build<UpdateProductRequest, UpdateProductResponse> {
            serializer = UpdateProductOperationSerializer()
            deserializer = UpdateProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests updates to the configuration of the specified provisioned product.
     *
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.
     *
     * You can check the status of this request using DescribeRecord.
     */
    override suspend fun updateProvisionedProduct(input: UpdateProvisionedProductRequest): UpdateProvisionedProductResponse {
        val op = SdkHttpOperation.build<UpdateProvisionedProductRequest, UpdateProvisionedProductResponse> {
            serializer = UpdateProvisionedProductOperationSerializer()
            deserializer = UpdateProvisionedProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProvisionedProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests updates to the properties of the specified provisioned product.
     */
    override suspend fun updateProvisionedProductProperties(input: UpdateProvisionedProductPropertiesRequest): UpdateProvisionedProductPropertiesResponse {
        val op = SdkHttpOperation.build<UpdateProvisionedProductPropertiesRequest, UpdateProvisionedProductPropertiesResponse> {
            serializer = UpdateProvisionedProductPropertiesOperationSerializer()
            deserializer = UpdateProvisionedProductPropertiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProvisionedProductProperties"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot update a provisioning artifact for a product that was shared with you.
     */
    override suspend fun updateProvisioningArtifact(input: UpdateProvisioningArtifactRequest): UpdateProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<UpdateProvisioningArtifactRequest, UpdateProvisioningArtifactResponse> {
            serializer = UpdateProvisioningArtifactOperationSerializer()
            deserializer = UpdateProvisioningArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProvisioningArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a self-service action.
     */
    override suspend fun updateServiceAction(input: UpdateServiceActionRequest): UpdateServiceActionResponse {
        val op = SdkHttpOperation.build<UpdateServiceActionRequest, UpdateServiceActionResponse> {
            serializer = UpdateServiceActionOperationSerializer()
            deserializer = UpdateServiceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified TagOption.
     */
    override suspend fun updateTagOption(input: UpdateTagOptionRequest): UpdateTagOptionResponse {
        val op = SdkHttpOperation.build<UpdateTagOptionRequest, UpdateTagOptionResponse> {
            serializer = UpdateTagOptionOperationSerializer()
            deserializer = UpdateTagOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTagOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicecatalog"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "servicecatalog")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
