// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.servicecatalog.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.servicecatalog.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS Service Catalog
 * [AWS Service Catalog](https://aws.amazon.com/servicecatalog/) enables organizations to create and manage catalogs of IT services that are approved for AWS. To get the most out of this documentation, you should be familiar with the terminology discussed in [AWS Service Catalog Concepts](http://docs.aws.amazon.com/servicecatalog/latest/adminguide/what-is_concepts.html).
 */
interface ServiceCatalogClient : SdkClient {

    override val serviceName: String
        get() = "Service Catalog"
    /**
     * ServiceCatalogClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ServiceCatalogClient {
            val config = Config.Builder().apply(block).build()
            return DefaultServiceCatalogClient(config)
        }

        operator fun invoke(config: Config): ServiceCatalogClient = DefaultServiceCatalogClient(config)

        /**
         * Construct a [ServiceCatalogClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ServiceCatalogClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultServiceCatalogClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts an offer to share the specified portfolio.
     */
    suspend fun acceptPortfolioShare(input: AcceptPortfolioShareRequest): AcceptPortfolioShareResponse

    /**
     * Accepts an offer to share the specified portfolio.
     */
    suspend fun acceptPortfolioShare(block: AcceptPortfolioShareRequest.Builder.() -> Unit) = acceptPortfolioShare(AcceptPortfolioShareRequest.Builder().apply(block).build())

    /**
     * Associates the specified budget with the specified resource.
     */
    suspend fun associateBudgetWithResource(input: AssociateBudgetWithResourceRequest): AssociateBudgetWithResourceResponse

    /**
     * Associates the specified budget with the specified resource.
     */
    suspend fun associateBudgetWithResource(block: AssociateBudgetWithResourceRequest.Builder.() -> Unit) = associateBudgetWithResource(AssociateBudgetWithResourceRequest.Builder().apply(block).build())

    /**
     * Associates the specified principal ARN with the specified portfolio.
     */
    suspend fun associatePrincipalWithPortfolio(input: AssociatePrincipalWithPortfolioRequest): AssociatePrincipalWithPortfolioResponse

    /**
     * Associates the specified principal ARN with the specified portfolio.
     */
    suspend fun associatePrincipalWithPortfolio(block: AssociatePrincipalWithPortfolioRequest.Builder.() -> Unit) = associatePrincipalWithPortfolio(AssociatePrincipalWithPortfolioRequest.Builder().apply(block).build())

    /**
     * Associates the specified product with the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun associateProductWithPortfolio(input: AssociateProductWithPortfolioRequest): AssociateProductWithPortfolioResponse

    /**
     * Associates the specified product with the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun associateProductWithPortfolio(block: AssociateProductWithPortfolioRequest.Builder.() -> Unit) = associateProductWithPortfolio(AssociateProductWithPortfolioRequest.Builder().apply(block).build())

    /**
     * Associates a self-service action with a provisioning artifact.
     */
    suspend fun associateServiceActionWithProvisioningArtifact(input: AssociateServiceActionWithProvisioningArtifactRequest): AssociateServiceActionWithProvisioningArtifactResponse

    /**
     * Associates a self-service action with a provisioning artifact.
     */
    suspend fun associateServiceActionWithProvisioningArtifact(block: AssociateServiceActionWithProvisioningArtifactRequest.Builder.() -> Unit) = associateServiceActionWithProvisioningArtifact(AssociateServiceActionWithProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Associate the specified TagOption with the specified portfolio or product.
     */
    suspend fun associateTagOptionWithResource(input: AssociateTagOptionWithResourceRequest): AssociateTagOptionWithResourceResponse

    /**
     * Associate the specified TagOption with the specified portfolio or product.
     */
    suspend fun associateTagOptionWithResource(block: AssociateTagOptionWithResourceRequest.Builder.() -> Unit) = associateTagOptionWithResource(AssociateTagOptionWithResourceRequest.Builder().apply(block).build())

    /**
     * Associates multiple self-service actions with provisioning artifacts.
     */
    suspend fun batchAssociateServiceActionWithProvisioningArtifact(input: BatchAssociateServiceActionWithProvisioningArtifactRequest): BatchAssociateServiceActionWithProvisioningArtifactResponse

    /**
     * Associates multiple self-service actions with provisioning artifacts.
     */
    suspend fun batchAssociateServiceActionWithProvisioningArtifact(block: BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder.() -> Unit) = batchAssociateServiceActionWithProvisioningArtifact(BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     */
    suspend fun batchDisassociateServiceActionFromProvisioningArtifact(input: BatchDisassociateServiceActionFromProvisioningArtifactRequest): BatchDisassociateServiceActionFromProvisioningArtifactResponse

    /**
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     */
    suspend fun batchDisassociateServiceActionFromProvisioningArtifact(block: BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder.() -> Unit) = batchDisassociateServiceActionFromProvisioningArtifact(BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Copies the specified source product to the specified target product or a new product.
     *
     * You can copy a product to the same account or another account. You can copy a product to the same region or another region.
     *
     * This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.
     */
    suspend fun copyProduct(input: CopyProductRequest): CopyProductResponse

    /**
     * Copies the specified source product to the specified target product or a new product.
     *
     * You can copy a product to the same account or another account. You can copy a product to the same region or another region.
     *
     * This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.
     */
    suspend fun copyProduct(block: CopyProductRequest.Builder.() -> Unit) = copyProduct(CopyProductRequest.Builder().apply(block).build())

    /**
     * Creates a constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun createConstraint(input: CreateConstraintRequest): CreateConstraintResponse

    /**
     * Creates a constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun createConstraint(block: CreateConstraintRequest.Builder.() -> Unit) = createConstraint(CreateConstraintRequest.Builder().apply(block).build())

    /**
     * Creates a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun createPortfolio(input: CreatePortfolioRequest): CreatePortfolioResponse

    /**
     * Creates a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun createPortfolio(block: CreatePortfolioRequest.Builder.() -> Unit) = createPortfolio(CreatePortfolioRequest.Builder().apply(block).build())

    /**
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
     *
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     *
     * `AWSOrganizationsAccess` must be enabled in order to create a portfolio share to an organization node.
     *
     * You can't share a shared resource, including portfolios that contain a shared product.
     *
     * If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the ` UpdatePortfolioShare` API instead.
     */
    suspend fun createPortfolioShare(input: CreatePortfolioShareRequest): CreatePortfolioShareResponse

    /**
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
     *
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     *
     * `AWSOrganizationsAccess` must be enabled in order to create a portfolio share to an organization node.
     *
     * You can't share a shared resource, including portfolios that contain a shared product.
     *
     * If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the ` UpdatePortfolioShare` API instead.
     */
    suspend fun createPortfolioShare(block: CreatePortfolioShareRequest.Builder.() -> Unit) = createPortfolioShare(CreatePortfolioShareRequest.Builder().apply(block).build())

    /**
     * Creates a product.
     *
     * A delegated admin is authorized to invoke this command.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    suspend fun createProduct(input: CreateProductRequest): CreateProductResponse

    /**
     * Creates a product.
     *
     * A delegated admin is authorized to invoke this command.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    suspend fun createProduct(block: CreateProductRequest.Builder.() -> Unit) = createProduct(CreateProductRequest.Builder().apply(block).build())

    /**
     * Creates a plan. A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.
     *
     * You can create one plan per provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILBLE or TAINTED.
     *
     * To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.
     */
    suspend fun createProvisionedProductPlan(input: CreateProvisionedProductPlanRequest): CreateProvisionedProductPlanResponse

    /**
     * Creates a plan. A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.
     *
     * You can create one plan per provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILBLE or TAINTED.
     *
     * To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.
     */
    suspend fun createProvisionedProductPlan(block: CreateProvisionedProductPlanRequest.Builder.() -> Unit) = createProvisionedProductPlan(CreateProvisionedProductPlanRequest.Builder().apply(block).build())

    /**
     * Creates a provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot create a provisioning artifact for a product that was shared with you.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    suspend fun createProvisioningArtifact(input: CreateProvisioningArtifactRequest): CreateProvisioningArtifactResponse

    /**
     * Creates a provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot create a provisioning artifact for a product that was shared with you.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    suspend fun createProvisioningArtifact(block: CreateProvisioningArtifactRequest.Builder.() -> Unit) = createProvisioningArtifact(CreateProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Creates a self-service action.
     */
    suspend fun createServiceAction(input: CreateServiceActionRequest): CreateServiceActionResponse

    /**
     * Creates a self-service action.
     */
    suspend fun createServiceAction(block: CreateServiceActionRequest.Builder.() -> Unit) = createServiceAction(CreateServiceActionRequest.Builder().apply(block).build())

    /**
     * Creates a TagOption.
     */
    suspend fun createTagOption(input: CreateTagOptionRequest): CreateTagOptionResponse

    /**
     * Creates a TagOption.
     */
    suspend fun createTagOption(block: CreateTagOptionRequest.Builder.() -> Unit) = createTagOption(CreateTagOptionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun deleteConstraint(input: DeleteConstraintRequest): DeleteConstraintResponse

    /**
     * Deletes the specified constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun deleteConstraint(block: DeleteConstraintRequest.Builder.() -> Unit) = deleteConstraint(DeleteConstraintRequest.Builder().apply(block).build())

    /**
     * Deletes the specified portfolio.
     *
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun deletePortfolio(input: DeletePortfolioRequest): DeletePortfolioResponse

    /**
     * Deletes the specified portfolio.
     *
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun deletePortfolio(block: DeletePortfolioRequest.Builder.() -> Unit) = deletePortfolio(DeletePortfolioRequest.Builder().apply(block).build())

    /**
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
     *
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     */
    suspend fun deletePortfolioShare(input: DeletePortfolioShareRequest): DeletePortfolioShareResponse

    /**
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
     *
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     */
    suspend fun deletePortfolioShare(block: DeletePortfolioShareRequest.Builder.() -> Unit) = deletePortfolioShare(DeletePortfolioShareRequest.Builder().apply(block).build())

    /**
     * Deletes the specified product.
     *
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun deleteProduct(input: DeleteProductRequest): DeleteProductResponse

    /**
     * Deletes the specified product.
     *
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun deleteProduct(block: DeleteProductRequest.Builder.() -> Unit) = deleteProduct(DeleteProductRequest.Builder().apply(block).build())

    /**
     * Deletes the specified plan.
     */
    suspend fun deleteProvisionedProductPlan(input: DeleteProvisionedProductPlanRequest): DeleteProvisionedProductPlanResponse

    /**
     * Deletes the specified plan.
     */
    suspend fun deleteProvisionedProductPlan(block: DeleteProvisionedProductPlanRequest.Builder.() -> Unit) = deleteProvisionedProductPlan(DeleteProvisionedProductPlanRequest.Builder().apply(block).build())

    /**
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     */
    suspend fun deleteProvisioningArtifact(input: DeleteProvisioningArtifactRequest): DeleteProvisioningArtifactResponse

    /**
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     */
    suspend fun deleteProvisioningArtifact(block: DeleteProvisioningArtifactRequest.Builder.() -> Unit) = deleteProvisioningArtifact(DeleteProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Deletes a self-service action.
     */
    suspend fun deleteServiceAction(input: DeleteServiceActionRequest): DeleteServiceActionResponse

    /**
     * Deletes a self-service action.
     */
    suspend fun deleteServiceAction(block: DeleteServiceActionRequest.Builder.() -> Unit) = deleteServiceAction(DeleteServiceActionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified TagOption.
     *
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     */
    suspend fun deleteTagOption(input: DeleteTagOptionRequest): DeleteTagOptionResponse

    /**
     * Deletes the specified TagOption.
     *
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     */
    suspend fun deleteTagOption(block: DeleteTagOptionRequest.Builder.() -> Unit) = deleteTagOption(DeleteTagOptionRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified constraint.
     */
    suspend fun describeConstraint(input: DescribeConstraintRequest): DescribeConstraintResponse

    /**
     * Gets information about the specified constraint.
     */
    suspend fun describeConstraint(block: DescribeConstraintRequest.Builder.() -> Unit) = describeConstraint(DescribeConstraintRequest.Builder().apply(block).build())

    /**
     * Gets the status of the specified copy product operation.
     */
    suspend fun describeCopyProductStatus(input: DescribeCopyProductStatusRequest): DescribeCopyProductStatusResponse

    /**
     * Gets the status of the specified copy product operation.
     */
    suspend fun describeCopyProductStatus(block: DescribeCopyProductStatusRequest.Builder.() -> Unit) = describeCopyProductStatus(DescribeCopyProductStatusRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun describePortfolio(input: DescribePortfolioRequest): DescribePortfolioResponse

    /**
     * Gets information about the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun describePortfolio(block: DescribePortfolioRequest.Builder.() -> Unit) = describePortfolio(DescribePortfolioRequest.Builder().apply(block).build())

    /**
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
     */
    suspend fun describePortfolioShareStatus(input: DescribePortfolioShareStatusRequest): DescribePortfolioShareStatusResponse

    /**
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
     */
    suspend fun describePortfolioShareStatus(block: DescribePortfolioShareStatusRequest.Builder.() -> Unit) = describePortfolioShareStatus(DescribePortfolioShareStatusRequest.Builder().apply(block).build())

    /**
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     *
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.
     *
     * The `PortfolioId` and `Type` parameters are both required.
     */
    suspend fun describePortfolioShares(input: DescribePortfolioSharesRequest): DescribePortfolioSharesResponse

    /**
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     *
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.
     *
     * The `PortfolioId` and `Type` parameters are both required.
     */
    suspend fun describePortfolioShares(block: DescribePortfolioSharesRequest.Builder.() -> Unit) = describePortfolioShares(DescribePortfolioSharesRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified product.
     */
    suspend fun describeProduct(input: DescribeProductRequest = DescribeProductRequest {}): DescribeProductResponse

    /**
     * Gets information about the specified product.
     */
    suspend fun describeProduct(block: DescribeProductRequest.Builder.() -> Unit) = describeProduct(DescribeProductRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified product. This operation is run with administrator access.
     */
    suspend fun describeProductAsAdmin(input: DescribeProductAsAdminRequest = DescribeProductAsAdminRequest {}): DescribeProductAsAdminResponse

    /**
     * Gets information about the specified product. This operation is run with administrator access.
     */
    suspend fun describeProductAsAdmin(block: DescribeProductAsAdminRequest.Builder.() -> Unit) = describeProductAsAdmin(DescribeProductAsAdminRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified product.
     */
    suspend fun describeProductView(input: DescribeProductViewRequest): DescribeProductViewResponse

    /**
     * Gets information about the specified product.
     */
    suspend fun describeProductView(block: DescribeProductViewRequest.Builder.() -> Unit) = describeProductView(DescribeProductViewRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified provisioned product.
     */
    suspend fun describeProvisionedProduct(input: DescribeProvisionedProductRequest = DescribeProvisionedProductRequest {}): DescribeProvisionedProductResponse

    /**
     * Gets information about the specified provisioned product.
     */
    suspend fun describeProvisionedProduct(block: DescribeProvisionedProductRequest.Builder.() -> Unit) = describeProvisionedProduct(DescribeProvisionedProductRequest.Builder().apply(block).build())

    /**
     * Gets information about the resource changes for the specified plan.
     */
    suspend fun describeProvisionedProductPlan(input: DescribeProvisionedProductPlanRequest): DescribeProvisionedProductPlanResponse

    /**
     * Gets information about the resource changes for the specified plan.
     */
    suspend fun describeProvisionedProductPlan(block: DescribeProvisionedProductPlanRequest.Builder.() -> Unit) = describeProvisionedProductPlan(DescribeProvisionedProductPlanRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     */
    suspend fun describeProvisioningArtifact(input: DescribeProvisioningArtifactRequest = DescribeProvisioningArtifactRequest {}): DescribeProvisioningArtifactResponse

    /**
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     */
    suspend fun describeProvisioningArtifact(block: DescribeProvisioningArtifactRequest.Builder.() -> Unit) = describeProvisioningArtifact(DescribeProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
     *
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*". Tag the provisioned product with the value `sc-tagoption-conflict-portfolioId-productId`.
     */
    suspend fun describeProvisioningParameters(input: DescribeProvisioningParametersRequest = DescribeProvisioningParametersRequest {}): DescribeProvisioningParametersResponse

    /**
     * Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
     *
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*". Tag the provisioned product with the value `sc-tagoption-conflict-portfolioId-productId`.
     */
    suspend fun describeProvisioningParameters(block: DescribeProvisioningParametersRequest.Builder.() -> Unit) = describeProvisioningParameters(DescribeProvisioningParametersRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified request operation.
     *
     * Use this operation after calling a request operation (for example, ProvisionProduct, TerminateProvisionedProduct, or UpdateProvisionedProduct).
     *
     * If a provisioned product was transferred to a new owner using UpdateProvisionedProductProperties, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use ListRecordHistory to see the product's history from when he was the owner.
     */
    suspend fun describeRecord(input: DescribeRecordRequest): DescribeRecordResponse

    /**
     * Gets information about the specified request operation.
     *
     * Use this operation after calling a request operation (for example, ProvisionProduct, TerminateProvisionedProduct, or UpdateProvisionedProduct).
     *
     * If a provisioned product was transferred to a new owner using UpdateProvisionedProductProperties, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use ListRecordHistory to see the product's history from when he was the owner.
     */
    suspend fun describeRecord(block: DescribeRecordRequest.Builder.() -> Unit) = describeRecord(DescribeRecordRequest.Builder().apply(block).build())

    /**
     * Describes a self-service action.
     */
    suspend fun describeServiceAction(input: DescribeServiceActionRequest): DescribeServiceActionResponse

    /**
     * Describes a self-service action.
     */
    suspend fun describeServiceAction(block: DescribeServiceActionRequest.Builder.() -> Unit) = describeServiceAction(DescribeServiceActionRequest.Builder().apply(block).build())

    /**
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
     */
    suspend fun describeServiceActionExecutionParameters(input: DescribeServiceActionExecutionParametersRequest): DescribeServiceActionExecutionParametersResponse

    /**
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
     */
    suspend fun describeServiceActionExecutionParameters(block: DescribeServiceActionExecutionParametersRequest.Builder.() -> Unit) = describeServiceActionExecutionParameters(DescribeServiceActionExecutionParametersRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified TagOption.
     */
    suspend fun describeTagOption(input: DescribeTagOptionRequest): DescribeTagOptionResponse

    /**
     * Gets information about the specified TagOption.
     */
    suspend fun describeTagOption(block: DescribeTagOptionRequest.Builder.() -> Unit) = describeTagOption(DescribeTagOptionRequest.Builder().apply(block).build())

    /**
     * Disable portfolio sharing through AWS Organizations feature. This feature will not delete your current shares but it will prevent you from creating new shares throughout your organization. Current shares will not be in sync with your organization structure if it changes after calling this API. This API can only be called by the management account in the organization.
     *
     * This API can't be invoked if there are active delegated administrators in the organization.
     *
     * Note that a delegated administrator is not authorized to invoke `DisableAWSOrganizationsAccess`.
     */
    suspend fun disableAwsOrganizationsAccess(input: DisableAwsOrganizationsAccessRequest = DisableAwsOrganizationsAccessRequest {}): DisableAwsOrganizationsAccessResponse

    /**
     * Disable portfolio sharing through AWS Organizations feature. This feature will not delete your current shares but it will prevent you from creating new shares throughout your organization. Current shares will not be in sync with your organization structure if it changes after calling this API. This API can only be called by the management account in the organization.
     *
     * This API can't be invoked if there are active delegated administrators in the organization.
     *
     * Note that a delegated administrator is not authorized to invoke `DisableAWSOrganizationsAccess`.
     */
    suspend fun disableAwsOrganizationsAccess(block: DisableAwsOrganizationsAccessRequest.Builder.() -> Unit) = disableAwsOrganizationsAccess(DisableAwsOrganizationsAccessRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified budget from the specified resource.
     */
    suspend fun disassociateBudgetFromResource(input: DisassociateBudgetFromResourceRequest): DisassociateBudgetFromResourceResponse

    /**
     * Disassociates the specified budget from the specified resource.
     */
    suspend fun disassociateBudgetFromResource(block: DisassociateBudgetFromResourceRequest.Builder.() -> Unit) = disassociateBudgetFromResource(DisassociateBudgetFromResourceRequest.Builder().apply(block).build())

    /**
     * Disassociates a previously associated principal ARN from a specified portfolio.
     */
    suspend fun disassociatePrincipalFromPortfolio(input: DisassociatePrincipalFromPortfolioRequest): DisassociatePrincipalFromPortfolioResponse

    /**
     * Disassociates a previously associated principal ARN from a specified portfolio.
     */
    suspend fun disassociatePrincipalFromPortfolio(block: DisassociatePrincipalFromPortfolioRequest.Builder.() -> Unit) = disassociatePrincipalFromPortfolio(DisassociatePrincipalFromPortfolioRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified product from the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun disassociateProductFromPortfolio(input: DisassociateProductFromPortfolioRequest): DisassociateProductFromPortfolioResponse

    /**
     * Disassociates the specified product from the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    suspend fun disassociateProductFromPortfolio(block: DisassociateProductFromPortfolioRequest.Builder.() -> Unit) = disassociateProductFromPortfolio(DisassociateProductFromPortfolioRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     */
    suspend fun disassociateServiceActionFromProvisioningArtifact(input: DisassociateServiceActionFromProvisioningArtifactRequest): DisassociateServiceActionFromProvisioningArtifactResponse

    /**
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     */
    suspend fun disassociateServiceActionFromProvisioningArtifact(block: DisassociateServiceActionFromProvisioningArtifactRequest.Builder.() -> Unit) = disassociateServiceActionFromProvisioningArtifact(DisassociateServiceActionFromProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified TagOption from the specified resource.
     */
    suspend fun disassociateTagOptionFromResource(input: DisassociateTagOptionFromResourceRequest): DisassociateTagOptionFromResourceResponse

    /**
     * Disassociates the specified TagOption from the specified resource.
     */
    suspend fun disassociateTagOptionFromResource(block: DisassociateTagOptionFromResourceRequest.Builder.() -> Unit) = disassociateTagOptionFromResource(DisassociateTagOptionFromResourceRequest.Builder().apply(block).build())

    /**
     * Enable portfolio sharing feature through AWS Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
     *
     * By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure.
     *
     * Note that a delegated administrator is not authorized to invoke `EnableAWSOrganizationsAccess`.
     */
    suspend fun enableAwsOrganizationsAccess(input: EnableAwsOrganizationsAccessRequest = EnableAwsOrganizationsAccessRequest {}): EnableAwsOrganizationsAccessResponse

    /**
     * Enable portfolio sharing feature through AWS Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
     *
     * By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure.
     *
     * Note that a delegated administrator is not authorized to invoke `EnableAWSOrganizationsAccess`.
     */
    suspend fun enableAwsOrganizationsAccess(block: EnableAwsOrganizationsAccessRequest.Builder.() -> Unit) = enableAwsOrganizationsAccess(EnableAwsOrganizationsAccessRequest.Builder().apply(block).build())

    /**
     * Provisions or modifies a product based on the resource changes for the specified plan.
     */
    suspend fun executeProvisionedProductPlan(input: ExecuteProvisionedProductPlanRequest): ExecuteProvisionedProductPlanResponse

    /**
     * Provisions or modifies a product based on the resource changes for the specified plan.
     */
    suspend fun executeProvisionedProductPlan(block: ExecuteProvisionedProductPlanRequest.Builder.() -> Unit) = executeProvisionedProductPlan(ExecuteProvisionedProductPlanRequest.Builder().apply(block).build())

    /**
     * Executes a self-service action against a provisioned product.
     */
    suspend fun executeProvisionedProductServiceAction(input: ExecuteProvisionedProductServiceActionRequest): ExecuteProvisionedProductServiceActionResponse

    /**
     * Executes a self-service action against a provisioned product.
     */
    suspend fun executeProvisionedProductServiceAction(block: ExecuteProvisionedProductServiceActionRequest.Builder.() -> Unit) = executeProvisionedProductServiceAction(ExecuteProvisionedProductServiceActionRequest.Builder().apply(block).build())

    /**
     * Get the Access Status for AWS Organization portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
     */
    suspend fun getAwsOrganizationsAccessStatus(input: GetAwsOrganizationsAccessStatusRequest = GetAwsOrganizationsAccessStatusRequest {}): GetAwsOrganizationsAccessStatusResponse

    /**
     * Get the Access Status for AWS Organization portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
     */
    suspend fun getAwsOrganizationsAccessStatus(block: GetAwsOrganizationsAccessStatusRequest.Builder.() -> Unit) = getAwsOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest.Builder().apply(block).build())

    /**
     * This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
     */
    suspend fun getProvisionedProductOutputs(input: GetProvisionedProductOutputsRequest = GetProvisionedProductOutputsRequest {}): GetProvisionedProductOutputsResponse

    /**
     * This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
     */
    suspend fun getProvisionedProductOutputs(block: GetProvisionedProductOutputsRequest.Builder.() -> Unit) = getProvisionedProductOutputs(GetProvisionedProductOutputsRequest.Builder().apply(block).build())

    /**
     * Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are supported on the provisioned product.
     *
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and non-root nested stacks are not supported.
     *
     * The CloudFormation stack must have one of the following statuses to be imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`, `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`, `IMPORT_ROLLBACK_COMPLETE`.
     *
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM policy permissions.
     */
    suspend fun importAsProvisionedProduct(input: ImportAsProvisionedProductRequest): ImportAsProvisionedProductResponse

    /**
     * Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are supported on the provisioned product.
     *
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and non-root nested stacks are not supported.
     *
     * The CloudFormation stack must have one of the following statuses to be imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`, `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`, `IMPORT_ROLLBACK_COMPLETE`.
     *
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM policy permissions.
     */
    suspend fun importAsProvisionedProduct(block: ImportAsProvisionedProductRequest.Builder.() -> Unit) = importAsProvisionedProduct(ImportAsProvisionedProductRequest.Builder().apply(block).build())

    /**
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
     */
    suspend fun listAcceptedPortfolioShares(input: ListAcceptedPortfolioSharesRequest = ListAcceptedPortfolioSharesRequest {}): ListAcceptedPortfolioSharesResponse

    /**
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
     */
    suspend fun listAcceptedPortfolioShares(block: ListAcceptedPortfolioSharesRequest.Builder.() -> Unit) = listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest.Builder().apply(block).build())

    /**
     * Lists all the budgets associated to the specified resource.
     */
    suspend fun listBudgetsForResource(input: ListBudgetsForResourceRequest): ListBudgetsForResourceResponse

    /**
     * Lists all the budgets associated to the specified resource.
     */
    suspend fun listBudgetsForResource(block: ListBudgetsForResourceRequest.Builder.() -> Unit) = listBudgetsForResource(ListBudgetsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the constraints for the specified portfolio and product.
     */
    suspend fun listConstraintsForPortfolio(input: ListConstraintsForPortfolioRequest): ListConstraintsForPortfolioResponse

    /**
     * Lists the constraints for the specified portfolio and product.
     */
    suspend fun listConstraintsForPortfolio(block: ListConstraintsForPortfolioRequest.Builder.() -> Unit) = listConstraintsForPortfolio(ListConstraintsForPortfolioRequest.Builder().apply(block).build())

    /**
     * Lists the paths to the specified product. A path is how the user has access to a specified product, and is necessary when provisioning a product. A path also determines the constraints put on the product.
     */
    suspend fun listLaunchPaths(input: ListLaunchPathsRequest): ListLaunchPathsResponse

    /**
     * Lists the paths to the specified product. A path is how the user has access to a specified product, and is necessary when provisioning a product. A path also determines the constraints put on the product.
     */
    suspend fun listLaunchPaths(block: ListLaunchPathsRequest.Builder.() -> Unit) = listLaunchPaths(ListLaunchPathsRequest.Builder().apply(block).build())

    /**
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
     *
     * If a delegated admin is de-registered, they can no longer perform this operation.
     */
    suspend fun listOrganizationPortfolioAccess(input: ListOrganizationPortfolioAccessRequest): ListOrganizationPortfolioAccessResponse

    /**
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
     *
     * If a delegated admin is de-registered, they can no longer perform this operation.
     */
    suspend fun listOrganizationPortfolioAccess(block: ListOrganizationPortfolioAccessRequest.Builder.() -> Unit) = listOrganizationPortfolioAccess(ListOrganizationPortfolioAccessRequest.Builder().apply(block).build())

    /**
     * Lists the account IDs that have access to the specified portfolio.
     *
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.
     */
    suspend fun listPortfolioAccess(input: ListPortfolioAccessRequest): ListPortfolioAccessResponse

    /**
     * Lists the account IDs that have access to the specified portfolio.
     *
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.
     */
    suspend fun listPortfolioAccess(block: ListPortfolioAccessRequest.Builder.() -> Unit) = listPortfolioAccess(ListPortfolioAccessRequest.Builder().apply(block).build())

    /**
     * Lists all portfolios in the catalog.
     */
    suspend fun listPortfolios(input: ListPortfoliosRequest = ListPortfoliosRequest {}): ListPortfoliosResponse

    /**
     * Lists all portfolios in the catalog.
     */
    suspend fun listPortfolios(block: ListPortfoliosRequest.Builder.() -> Unit) = listPortfolios(ListPortfoliosRequest.Builder().apply(block).build())

    /**
     * Lists all portfolios that the specified product is associated with.
     */
    suspend fun listPortfoliosForProduct(input: ListPortfoliosForProductRequest): ListPortfoliosForProductResponse

    /**
     * Lists all portfolios that the specified product is associated with.
     */
    suspend fun listPortfoliosForProduct(block: ListPortfoliosForProductRequest.Builder.() -> Unit) = listPortfoliosForProduct(ListPortfoliosForProductRequest.Builder().apply(block).build())

    /**
     * Lists all principal ARNs associated with the specified portfolio.
     */
    suspend fun listPrincipalsForPortfolio(input: ListPrincipalsForPortfolioRequest): ListPrincipalsForPortfolioResponse

    /**
     * Lists all principal ARNs associated with the specified portfolio.
     */
    suspend fun listPrincipalsForPortfolio(block: ListPrincipalsForPortfolioRequest.Builder.() -> Unit) = listPrincipalsForPortfolio(ListPrincipalsForPortfolioRequest.Builder().apply(block).build())

    /**
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     */
    suspend fun listProvisionedProductPlans(input: ListProvisionedProductPlansRequest = ListProvisionedProductPlansRequest {}): ListProvisionedProductPlansResponse

    /**
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     */
    suspend fun listProvisionedProductPlans(block: ListProvisionedProductPlansRequest.Builder.() -> Unit) = listProvisionedProductPlans(ListProvisionedProductPlansRequest.Builder().apply(block).build())

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     */
    suspend fun listProvisioningArtifacts(input: ListProvisioningArtifactsRequest): ListProvisioningArtifactsResponse

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     */
    suspend fun listProvisioningArtifacts(block: ListProvisioningArtifactsRequest.Builder.() -> Unit) = listProvisioningArtifacts(ListProvisioningArtifactsRequest.Builder().apply(block).build())

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     */
    suspend fun listProvisioningArtifactsForServiceAction(input: ListProvisioningArtifactsForServiceActionRequest): ListProvisioningArtifactsForServiceActionResponse

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     */
    suspend fun listProvisioningArtifactsForServiceAction(block: ListProvisioningArtifactsForServiceActionRequest.Builder.() -> Unit) = listProvisioningArtifactsForServiceAction(ListProvisioningArtifactsForServiceActionRequest.Builder().apply(block).build())

    /**
     * Lists the specified requests or all performed requests.
     */
    suspend fun listRecordHistory(input: ListRecordHistoryRequest = ListRecordHistoryRequest {}): ListRecordHistoryResponse

    /**
     * Lists the specified requests or all performed requests.
     */
    suspend fun listRecordHistory(block: ListRecordHistoryRequest.Builder.() -> Unit) = listRecordHistory(ListRecordHistoryRequest.Builder().apply(block).build())

    /**
     * Lists the resources associated with the specified TagOption.
     */
    suspend fun listResourcesForTagOption(input: ListResourcesForTagOptionRequest): ListResourcesForTagOptionResponse

    /**
     * Lists the resources associated with the specified TagOption.
     */
    suspend fun listResourcesForTagOption(block: ListResourcesForTagOptionRequest.Builder.() -> Unit) = listResourcesForTagOption(ListResourcesForTagOptionRequest.Builder().apply(block).build())

    /**
     * Lists all self-service actions.
     */
    suspend fun listServiceActions(input: ListServiceActionsRequest = ListServiceActionsRequest {}): ListServiceActionsResponse

    /**
     * Lists all self-service actions.
     */
    suspend fun listServiceActions(block: ListServiceActionsRequest.Builder.() -> Unit) = listServiceActions(ListServiceActionsRequest.Builder().apply(block).build())

    /**
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
     */
    suspend fun listServiceActionsForProvisioningArtifact(input: ListServiceActionsForProvisioningArtifactRequest): ListServiceActionsForProvisioningArtifactResponse

    /**
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
     */
    suspend fun listServiceActionsForProvisioningArtifact(block: ListServiceActionsForProvisioningArtifactRequest.Builder.() -> Unit) = listServiceActionsForProvisioningArtifact(ListServiceActionsForProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific AWS account name or region.
     */
    suspend fun listStackInstancesForProvisionedProduct(input: ListStackInstancesForProvisionedProductRequest): ListStackInstancesForProvisionedProductResponse

    /**
     * Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific AWS account name or region.
     */
    suspend fun listStackInstancesForProvisionedProduct(block: ListStackInstancesForProvisionedProductRequest.Builder.() -> Unit) = listStackInstancesForProvisionedProduct(ListStackInstancesForProvisionedProductRequest.Builder().apply(block).build())

    /**
     * Lists the specified TagOptions or all TagOptions.
     */
    suspend fun listTagOptions(input: ListTagOptionsRequest = ListTagOptionsRequest {}): ListTagOptionsResponse

    /**
     * Lists the specified TagOptions or all TagOptions.
     */
    suspend fun listTagOptions(block: ListTagOptionsRequest.Builder.() -> Unit) = listTagOptions(ListTagOptionsRequest.Builder().apply(block).build())

    /**
     * Provisions the specified product.
     *
     * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord.
     *
     * If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not include conflicted keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*".
     */
    suspend fun provisionProduct(input: ProvisionProductRequest): ProvisionProductResponse

    /**
     * Provisions the specified product.
     *
     * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord.
     *
     * If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not include conflicted keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*".
     */
    suspend fun provisionProduct(block: ProvisionProductRequest.Builder.() -> Unit) = provisionProduct(ProvisionProductRequest.Builder().apply(block).build())

    /**
     * Rejects an offer to share the specified portfolio.
     */
    suspend fun rejectPortfolioShare(input: RejectPortfolioShareRequest): RejectPortfolioShareResponse

    /**
     * Rejects an offer to share the specified portfolio.
     */
    suspend fun rejectPortfolioShare(block: RejectPortfolioShareRequest.Builder.() -> Unit) = rejectPortfolioShare(RejectPortfolioShareRequest.Builder().apply(block).build())

    /**
     * Lists the provisioned products that are available (not terminated).
     *
     * To use additional filtering, see SearchProvisionedProducts.
     */
    suspend fun scanProvisionedProducts(input: ScanProvisionedProductsRequest = ScanProvisionedProductsRequest {}): ScanProvisionedProductsResponse

    /**
     * Lists the provisioned products that are available (not terminated).
     *
     * To use additional filtering, see SearchProvisionedProducts.
     */
    suspend fun scanProvisionedProducts(block: ScanProvisionedProductsRequest.Builder.() -> Unit) = scanProvisionedProducts(ScanProvisionedProductsRequest.Builder().apply(block).build())

    /**
     * Gets information about the products to which the caller has access.
     */
    suspend fun searchProducts(input: SearchProductsRequest = SearchProductsRequest {}): SearchProductsResponse

    /**
     * Gets information about the products to which the caller has access.
     */
    suspend fun searchProducts(block: SearchProductsRequest.Builder.() -> Unit) = searchProducts(SearchProductsRequest.Builder().apply(block).build())

    /**
     * Gets information about the products for the specified portfolio or all products.
     */
    suspend fun searchProductsAsAdmin(input: SearchProductsAsAdminRequest = SearchProductsAsAdminRequest {}): SearchProductsAsAdminResponse

    /**
     * Gets information about the products for the specified portfolio or all products.
     */
    suspend fun searchProductsAsAdmin(block: SearchProductsAsAdminRequest.Builder.() -> Unit) = searchProductsAsAdmin(SearchProductsAsAdminRequest.Builder().apply(block).build())

    /**
     * Gets information about the provisioned products that meet the specified criteria.
     */
    suspend fun searchProvisionedProducts(input: SearchProvisionedProductsRequest = SearchProvisionedProductsRequest {}): SearchProvisionedProductsResponse

    /**
     * Gets information about the provisioned products that meet the specified criteria.
     */
    suspend fun searchProvisionedProducts(block: SearchProvisionedProductsRequest.Builder.() -> Unit) = searchProvisionedProducts(SearchProvisionedProductsRequest.Builder().apply(block).build())

    /**
     * Terminates the specified provisioned product.
     *
     * This operation does not delete any records associated with the provisioned product.
     *
     * You can check the status of this request using DescribeRecord.
     */
    suspend fun terminateProvisionedProduct(input: TerminateProvisionedProductRequest): TerminateProvisionedProductResponse

    /**
     * Terminates the specified provisioned product.
     *
     * This operation does not delete any records associated with the provisioned product.
     *
     * You can check the status of this request using DescribeRecord.
     */
    suspend fun terminateProvisionedProduct(block: TerminateProvisionedProductRequest.Builder.() -> Unit) = terminateProvisionedProduct(TerminateProvisionedProductRequest.Builder().apply(block).build())

    /**
     * Updates the specified constraint.
     */
    suspend fun updateConstraint(input: UpdateConstraintRequest): UpdateConstraintResponse

    /**
     * Updates the specified constraint.
     */
    suspend fun updateConstraint(block: UpdateConstraintRequest.Builder.() -> Unit) = updateConstraint(UpdateConstraintRequest.Builder().apply(block).build())

    /**
     * Updates the specified portfolio.
     *
     * You cannot update a product that was shared with you.
     */
    suspend fun updatePortfolio(input: UpdatePortfolioRequest): UpdatePortfolioResponse

    /**
     * Updates the specified portfolio.
     *
     * You cannot update a product that was shared with you.
     */
    suspend fun updatePortfolio(block: UpdatePortfolioRequest.Builder.() -> Unit) = updatePortfolio(UpdatePortfolioRequest.Builder().apply(block).build())

    /**
     * Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an existing portfolio share.
     *
     * The portfolio share cannot be updated if the ` CreatePortfolioShare` operation is `IN_PROGRESS`, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be COMPLETED.
     *
     * You must provide the `accountId` or organization node in the input, but not both.
     *
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke `UpdatePortfolioShare` separately for each share type.
     *
     * This API cannot be used for removing the portfolio share. You must use `DeletePortfolioShare` API for that action.
     */
    suspend fun updatePortfolioShare(input: UpdatePortfolioShareRequest): UpdatePortfolioShareResponse

    /**
     * Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an existing portfolio share.
     *
     * The portfolio share cannot be updated if the ` CreatePortfolioShare` operation is `IN_PROGRESS`, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be COMPLETED.
     *
     * You must provide the `accountId` or organization node in the input, but not both.
     *
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke `UpdatePortfolioShare` separately for each share type.
     *
     * This API cannot be used for removing the portfolio share. You must use `DeletePortfolioShare` API for that action.
     */
    suspend fun updatePortfolioShare(block: UpdatePortfolioShareRequest.Builder.() -> Unit) = updatePortfolioShare(UpdatePortfolioShareRequest.Builder().apply(block).build())

    /**
     * Updates the specified product.
     */
    suspend fun updateProduct(input: UpdateProductRequest): UpdateProductResponse

    /**
     * Updates the specified product.
     */
    suspend fun updateProduct(block: UpdateProductRequest.Builder.() -> Unit) = updateProduct(UpdateProductRequest.Builder().apply(block).build())

    /**
     * Requests updates to the configuration of the specified provisioned product.
     *
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.
     *
     * You can check the status of this request using DescribeRecord.
     */
    suspend fun updateProvisionedProduct(input: UpdateProvisionedProductRequest): UpdateProvisionedProductResponse

    /**
     * Requests updates to the configuration of the specified provisioned product.
     *
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.
     *
     * You can check the status of this request using DescribeRecord.
     */
    suspend fun updateProvisionedProduct(block: UpdateProvisionedProductRequest.Builder.() -> Unit) = updateProvisionedProduct(UpdateProvisionedProductRequest.Builder().apply(block).build())

    /**
     * Requests updates to the properties of the specified provisioned product.
     */
    suspend fun updateProvisionedProductProperties(input: UpdateProvisionedProductPropertiesRequest): UpdateProvisionedProductPropertiesResponse

    /**
     * Requests updates to the properties of the specified provisioned product.
     */
    suspend fun updateProvisionedProductProperties(block: UpdateProvisionedProductPropertiesRequest.Builder.() -> Unit) = updateProvisionedProductProperties(UpdateProvisionedProductPropertiesRequest.Builder().apply(block).build())

    /**
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot update a provisioning artifact for a product that was shared with you.
     */
    suspend fun updateProvisioningArtifact(input: UpdateProvisioningArtifactRequest): UpdateProvisioningArtifactResponse

    /**
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot update a provisioning artifact for a product that was shared with you.
     */
    suspend fun updateProvisioningArtifact(block: UpdateProvisioningArtifactRequest.Builder.() -> Unit) = updateProvisioningArtifact(UpdateProvisioningArtifactRequest.Builder().apply(block).build())

    /**
     * Updates a self-service action.
     */
    suspend fun updateServiceAction(input: UpdateServiceActionRequest): UpdateServiceActionResponse

    /**
     * Updates a self-service action.
     */
    suspend fun updateServiceAction(block: UpdateServiceActionRequest.Builder.() -> Unit) = updateServiceAction(UpdateServiceActionRequest.Builder().apply(block).build())

    /**
     * Updates the specified TagOption.
     */
    suspend fun updateTagOption(input: UpdateTagOptionRequest): UpdateTagOptionResponse

    /**
     * Updates the specified TagOption.
     */
    suspend fun updateTagOption(block: UpdateTagOptionRequest.Builder.() -> Unit) = updateTagOption(UpdateTagOptionRequest.Builder().apply(block).build())
}
