// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



class CreateServiceActionRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `en` - English (default)
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The self-service action definition. Can be one of the following:
     *
     * ## Name
     * The name of the AWS Systems Manager document (SSM document). For example, `AWS-RestartEC2Instance`.
     *
     * If you are using a shared SSM document, you must provide the ARN instead of the name.
     *
     * ## Version
     * The AWS Systems Manager automation document version. For example, `"Version": "1"`
     *
     * ## AssumeRole
     * The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, `"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"`.
     *
     * To reuse the provisioned product launch role, set to `"AssumeRole": "LAUNCH_ROLE"`.
     *
     * ## Parameters
     * The list of parameters in JSON format.
     *
     * For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
     */
    val definition: Map<String, String>? = builder.definition
    /**
     * The service action definition type. For example, `SSM_AUTOMATION`.
     */
    val definitionType: aws.sdk.kotlin.services.servicecatalog.model.ServiceActionDefinitionType? = builder.definitionType
    /**
     * The self-service action description.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The self-service action name.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.CreateServiceActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceActionRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("definition=$definition,")
        append("definitionType=$definitionType,")
        append("description=$description,")
        append("idempotencyToken=$idempotencyToken,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (definitionType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceActionRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (definition != other.definition) return false
        if (definitionType != other.definitionType) return false
        if (description != other.description) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.CreateServiceActionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code.
         * + `en` - English (default)
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        var acceptLanguage: kotlin.String? = null
        /**
         * The self-service action definition. Can be one of the following:
         *
         * ## Name
         * The name of the AWS Systems Manager document (SSM document). For example, `AWS-RestartEC2Instance`.
         *
         * If you are using a shared SSM document, you must provide the ARN instead of the name.
         *
         * ## Version
         * The AWS Systems Manager automation document version. For example, `"Version": "1"`
         *
         * ## AssumeRole
         * The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, `"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"`.
         *
         * To reuse the provisioned product launch role, set to `"AssumeRole": "LAUNCH_ROLE"`.
         *
         * ## Parameters
         * The list of parameters in JSON format.
         *
         * For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
         */
        var definition: Map<String, String>? = null
        /**
         * The service action definition type. For example, `SSM_AUTOMATION`.
         */
        var definitionType: aws.sdk.kotlin.services.servicecatalog.model.ServiceActionDefinitionType? = null
        /**
         * The self-service action description.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * The self-service action name.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.CreateServiceActionRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.definition = x.definition
            this.definitionType = x.definitionType
            this.description = x.description
            this.idempotencyToken = x.idempotencyToken
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.CreateServiceActionRequest = CreateServiceActionRequest(this)
    }
}
