// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



/**
 * Summary information about a product view.
 */
class ProductViewSummary private constructor(builder: Builder) {
    /**
     * The distributor of the product. Contact the product administrator for the significance of this value.
     */
    val distributor: kotlin.String? = builder.distributor
    /**
     * Indicates whether the product has a default path. If the product does not have a default path, call ListLaunchPaths to disambiguate between paths. Otherwise, ListLaunchPaths is not required, and the output of ProductViewSummary can be used directly with DescribeProvisioningParameters.
     */
    val hasDefaultPath: kotlin.Boolean = builder.hasDefaultPath
    /**
     * The product view identifier.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the product.
     */
    val name: kotlin.String? = builder.name
    /**
     * The owner of the product. Contact the product administrator for the significance of this value.
     */
    val owner: kotlin.String? = builder.owner
    /**
     * The product identifier.
     */
    val productId: kotlin.String? = builder.productId
    /**
     * Short description of the product.
     */
    val shortDescription: kotlin.String? = builder.shortDescription
    /**
     * The description of the support for this Product.
     */
    val supportDescription: kotlin.String? = builder.supportDescription
    /**
     * The email contact information to obtain support for this Product.
     */
    val supportEmail: kotlin.String? = builder.supportEmail
    /**
     * The URL information to obtain support for this Product.
     */
    val supportUrl: kotlin.String? = builder.supportUrl
    /**
     * The product type. Contact the product administrator for the significance of this value. If this value is `MARKETPLACE`, the product was created by AWS Marketplace.
     */
    val type: aws.sdk.kotlin.services.servicecatalog.model.ProductType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductViewSummary(")
        append("distributor=$distributor,")
        append("hasDefaultPath=$hasDefaultPath,")
        append("id=$id,")
        append("name=$name,")
        append("owner=$owner,")
        append("productId=$productId,")
        append("shortDescription=$shortDescription,")
        append("supportDescription=$supportDescription,")
        append("supportEmail=$supportEmail,")
        append("supportUrl=$supportUrl,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = distributor?.hashCode() ?: 0
        result = 31 * result + (hasDefaultPath.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (shortDescription?.hashCode() ?: 0)
        result = 31 * result + (supportDescription?.hashCode() ?: 0)
        result = 31 * result + (supportEmail?.hashCode() ?: 0)
        result = 31 * result + (supportUrl?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductViewSummary

        if (distributor != other.distributor) return false
        if (hasDefaultPath != other.hasDefaultPath) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (productId != other.productId) return false
        if (shortDescription != other.shortDescription) return false
        if (supportDescription != other.supportDescription) return false
        if (supportEmail != other.supportEmail) return false
        if (supportUrl != other.supportUrl) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The distributor of the product. Contact the product administrator for the significance of this value.
         */
        var distributor: kotlin.String? = null
        /**
         * Indicates whether the product has a default path. If the product does not have a default path, call ListLaunchPaths to disambiguate between paths. Otherwise, ListLaunchPaths is not required, and the output of ProductViewSummary can be used directly with DescribeProvisioningParameters.
         */
        var hasDefaultPath: kotlin.Boolean = false
        /**
         * The product view identifier.
         */
        var id: kotlin.String? = null
        /**
         * The name of the product.
         */
        var name: kotlin.String? = null
        /**
         * The owner of the product. Contact the product administrator for the significance of this value.
         */
        var owner: kotlin.String? = null
        /**
         * The product identifier.
         */
        var productId: kotlin.String? = null
        /**
         * Short description of the product.
         */
        var shortDescription: kotlin.String? = null
        /**
         * The description of the support for this Product.
         */
        var supportDescription: kotlin.String? = null
        /**
         * The email contact information to obtain support for this Product.
         */
        var supportEmail: kotlin.String? = null
        /**
         * The URL information to obtain support for this Product.
         */
        var supportUrl: kotlin.String? = null
        /**
         * The product type. Contact the product administrator for the significance of this value. If this value is `MARKETPLACE`, the product was created by AWS Marketplace.
         */
        var type: aws.sdk.kotlin.services.servicecatalog.model.ProductType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary) : this() {
            this.distributor = x.distributor
            this.hasDefaultPath = x.hasDefaultPath
            this.id = x.id
            this.name = x.name
            this.owner = x.owner
            this.productId = x.productId
            this.shortDescription = x.shortDescription
            this.supportDescription = x.supportDescription
            this.supportEmail = x.supportEmail
            this.supportUrl = x.supportUrl
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary = ProductViewSummary(this)
    }
}
