// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



class ProvisionProductRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `en` - English (default)
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    val notificationArns: List<String>? = builder.notificationArns
    /**
     * The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use ListLaunchPaths. You must provide the name or ID, but not both.
     */
    val pathId: kotlin.String? = builder.pathId
    /**
     * The name of the path. You must provide the name or ID, but not both.
     */
    val pathName: kotlin.String? = builder.pathName
    /**
     * The product identifier. You must provide the name or ID, but not both.
     */
    val productId: kotlin.String? = builder.productId
    /**
     * The name of the product. You must provide the name or ID, but not both.
     */
    val productName: kotlin.String? = builder.productName
    /**
     * An idempotency token that uniquely identifies the provisioning request.
     */
    val provisionToken: kotlin.String? = builder.provisionToken
    /**
     * A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.
     */
    val provisionedProductName: kotlin.String? = builder.provisionedProductName
    /**
     * The identifier of the provisioning artifact. You must provide the name or ID, but not both.
     */
    val provisioningArtifactId: kotlin.String? = builder.provisioningArtifactId
    /**
     * The name of the provisioning artifact. You must provide the name or ID, but not both.
     */
    val provisioningArtifactName: kotlin.String? = builder.provisioningArtifactName
    /**
     * Parameters specified by the administrator that are required for provisioning the product.
     */
    val provisioningParameters: List<ProvisioningParameter>? = builder.provisioningParameters
    /**
     * An object that contains information about the provisioning preferences for a stack set.
     */
    val provisioningPreferences: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences? = builder.provisioningPreferences
    /**
     * One or more tags.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisionProductRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("notificationArns=$notificationArns,")
        append("pathId=$pathId,")
        append("pathName=$pathName,")
        append("productId=$productId,")
        append("productName=$productName,")
        append("provisionToken=$provisionToken,")
        append("provisionedProductName=$provisionedProductName,")
        append("provisioningArtifactId=$provisioningArtifactId,")
        append("provisioningArtifactName=$provisioningArtifactName,")
        append("provisioningParameters=$provisioningParameters,")
        append("provisioningPreferences=$provisioningPreferences,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (notificationArns?.hashCode() ?: 0)
        result = 31 * result + (pathId?.hashCode() ?: 0)
        result = 31 * result + (pathName?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (productName?.hashCode() ?: 0)
        result = 31 * result + (provisionToken?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductName?.hashCode() ?: 0)
        result = 31 * result + (provisioningArtifactId?.hashCode() ?: 0)
        result = 31 * result + (provisioningArtifactName?.hashCode() ?: 0)
        result = 31 * result + (provisioningParameters?.hashCode() ?: 0)
        result = 31 * result + (provisioningPreferences?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisionProductRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (notificationArns != other.notificationArns) return false
        if (pathId != other.pathId) return false
        if (pathName != other.pathName) return false
        if (productId != other.productId) return false
        if (productName != other.productName) return false
        if (provisionToken != other.provisionToken) return false
        if (provisionedProductName != other.provisionedProductName) return false
        if (provisioningArtifactId != other.provisioningArtifactId) return false
        if (provisioningArtifactName != other.provisioningArtifactName) return false
        if (provisioningParameters != other.provisioningParameters) return false
        if (provisioningPreferences != other.provisioningPreferences) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code.
         * + `en` - English (default)
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        var acceptLanguage: kotlin.String? = null
        /**
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         */
        var notificationArns: List<String>? = null
        /**
         * The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use ListLaunchPaths. You must provide the name or ID, but not both.
         */
        var pathId: kotlin.String? = null
        /**
         * The name of the path. You must provide the name or ID, but not both.
         */
        var pathName: kotlin.String? = null
        /**
         * The product identifier. You must provide the name or ID, but not both.
         */
        var productId: kotlin.String? = null
        /**
         * The name of the product. You must provide the name or ID, but not both.
         */
        var productName: kotlin.String? = null
        /**
         * An idempotency token that uniquely identifies the provisioning request.
         */
        var provisionToken: kotlin.String? = null
        /**
         * A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.
         */
        var provisionedProductName: kotlin.String? = null
        /**
         * The identifier of the provisioning artifact. You must provide the name or ID, but not both.
         */
        var provisioningArtifactId: kotlin.String? = null
        /**
         * The name of the provisioning artifact. You must provide the name or ID, but not both.
         */
        var provisioningArtifactName: kotlin.String? = null
        /**
         * Parameters specified by the administrator that are required for provisioning the product.
         */
        var provisioningParameters: List<ProvisioningParameter>? = null
        /**
         * An object that contains information about the provisioning preferences for a stack set.
         */
        var provisioningPreferences: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences? = null
        /**
         * One or more tags.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.notificationArns = x.notificationArns
            this.pathId = x.pathId
            this.pathName = x.pathName
            this.productId = x.productId
            this.productName = x.productName
            this.provisionToken = x.provisionToken
            this.provisionedProductName = x.provisionedProductName
            this.provisioningArtifactId = x.provisioningArtifactId
            this.provisioningArtifactName = x.provisioningArtifactName
            this.provisioningParameters = x.provisioningParameters
            this.provisioningPreferences = x.provisioningPreferences
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductRequest = ProvisionProductRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences] inside the given [block]
         */
        fun provisioningPreferences(block: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences.Builder.() -> kotlin.Unit) {
            this.provisioningPreferences = aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences.invoke(block)
        }
    }
}
