// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a provisioned product.
 */
class ProvisionedProductAttribute private constructor(builder: Builder) {
    /**
     * The ARN of the provisioned product.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The UTC time stamp of the creation time.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The identifier of the provisioned product.
     */
    val id: kotlin.String? = builder.id
    /**
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The record identifier of the last request performed on this provisioned product of the following types:
     * +  ProvisionedProduct
     * +  UpdateProvisionedProduct
     * +  ExecuteProvisionedProductPlan
     * +  TerminateProvisionedProduct
     */
    val lastProvisioningRecordId: kotlin.String? = builder.lastProvisioningRecordId
    /**
     * The record identifier of the last request performed on this provisioned product.
     */
    val lastRecordId: kotlin.String? = builder.lastRecordId
    /**
     * The record identifier of the last successful request performed on this provisioned product of the following types:
     * +  ProvisionedProduct
     * +  UpdateProvisionedProduct
     * +  ExecuteProvisionedProductPlan
     * +  TerminateProvisionedProduct
     */
    val lastSuccessfulProvisioningRecordId: kotlin.String? = builder.lastSuccessfulProvisioningRecordId
    /**
     * The user-friendly name of the provisioned product.
     */
    val name: kotlin.String? = builder.name
    /**
     * The assigned identifier for the resource, such as an EC2 instance ID or an S3 bucket name.
     */
    val physicalId: kotlin.String? = builder.physicalId
    /**
     * The product identifier.
     */
    val productId: kotlin.String? = builder.productId
    /**
     * The name of the product.
     */
    val productName: kotlin.String? = builder.productName
    /**
     * The identifier of the provisioning artifact.
     */
    val provisioningArtifactId: kotlin.String? = builder.provisioningArtifactId
    /**
     * The name of the provisioning artifact.
     */
    val provisioningArtifactName: kotlin.String? = builder.provisioningArtifactName
    /**
     * The current status of the provisioned product.
     * + `AVAILABLE` - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
     * + `UNDER_CHANGE` - Transitive state. Operations performed might not have valid results. Wait for an `AVAILABLE` status before performing operations.
     * + `TAINTED` - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
     * + `ERROR` - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
     * + `PLAN_IN_PROGRESS` - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an `AVAILABLE` status before performing operations.
     */
    val status: aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductStatus? = builder.status
    /**
     * The current status message of the provisioned product.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * One or more tags.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of provisioned product. The supported values are `CFN_STACK` and `CFN_STACKSET`.
     */
    val type: kotlin.String? = builder.type
    /**
     * The Amazon Resource Name (ARN) of the IAM user.
     */
    val userArn: kotlin.String? = builder.userArn
    /**
     * The ARN of the IAM user in the session. This ARN might contain a session ID.
     */
    val userArnSession: kotlin.String? = builder.userArnSession

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisionedProductAttribute(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("id=$id,")
        append("idempotencyToken=$idempotencyToken,")
        append("lastProvisioningRecordId=$lastProvisioningRecordId,")
        append("lastRecordId=$lastRecordId,")
        append("lastSuccessfulProvisioningRecordId=$lastSuccessfulProvisioningRecordId,")
        append("name=$name,")
        append("physicalId=$physicalId,")
        append("productId=$productId,")
        append("productName=$productName,")
        append("provisioningArtifactId=$provisioningArtifactId,")
        append("provisioningArtifactName=$provisioningArtifactName,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags,")
        append("type=$type,")
        append("userArn=$userArn,")
        append("userArnSession=$userArnSession)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (lastProvisioningRecordId?.hashCode() ?: 0)
        result = 31 * result + (lastRecordId?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulProvisioningRecordId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (physicalId?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (productName?.hashCode() ?: 0)
        result = 31 * result + (provisioningArtifactId?.hashCode() ?: 0)
        result = 31 * result + (provisioningArtifactName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        result = 31 * result + (userArnSession?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisionedProductAttribute

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (id != other.id) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (lastProvisioningRecordId != other.lastProvisioningRecordId) return false
        if (lastRecordId != other.lastRecordId) return false
        if (lastSuccessfulProvisioningRecordId != other.lastSuccessfulProvisioningRecordId) return false
        if (name != other.name) return false
        if (physicalId != other.physicalId) return false
        if (productId != other.productId) return false
        if (productName != other.productName) return false
        if (provisioningArtifactId != other.provisioningArtifactId) return false
        if (provisioningArtifactName != other.provisioningArtifactName) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (userArn != other.userArn) return false
        if (userArnSession != other.userArnSession) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductAttribute = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the provisioned product.
         */
        var arn: kotlin.String? = null
        /**
         * The UTC time stamp of the creation time.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the provisioned product.
         */
        var id: kotlin.String? = null
        /**
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * The record identifier of the last request performed on this provisioned product of the following types:
         * +  ProvisionedProduct
         * +  UpdateProvisionedProduct
         * +  ExecuteProvisionedProductPlan
         * +  TerminateProvisionedProduct
         */
        var lastProvisioningRecordId: kotlin.String? = null
        /**
         * The record identifier of the last request performed on this provisioned product.
         */
        var lastRecordId: kotlin.String? = null
        /**
         * The record identifier of the last successful request performed on this provisioned product of the following types:
         * +  ProvisionedProduct
         * +  UpdateProvisionedProduct
         * +  ExecuteProvisionedProductPlan
         * +  TerminateProvisionedProduct
         */
        var lastSuccessfulProvisioningRecordId: kotlin.String? = null
        /**
         * The user-friendly name of the provisioned product.
         */
        var name: kotlin.String? = null
        /**
         * The assigned identifier for the resource, such as an EC2 instance ID or an S3 bucket name.
         */
        var physicalId: kotlin.String? = null
        /**
         * The product identifier.
         */
        var productId: kotlin.String? = null
        /**
         * The name of the product.
         */
        var productName: kotlin.String? = null
        /**
         * The identifier of the provisioning artifact.
         */
        var provisioningArtifactId: kotlin.String? = null
        /**
         * The name of the provisioning artifact.
         */
        var provisioningArtifactName: kotlin.String? = null
        /**
         * The current status of the provisioned product.
         * + `AVAILABLE` - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
         * + `UNDER_CHANGE` - Transitive state. Operations performed might not have valid results. Wait for an `AVAILABLE` status before performing operations.
         * + `TAINTED` - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
         * + `ERROR` - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
         * + `PLAN_IN_PROGRESS` - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an `AVAILABLE` status before performing operations.
         */
        var status: aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductStatus? = null
        /**
         * The current status message of the provisioned product.
         */
        var statusMessage: kotlin.String? = null
        /**
         * One or more tags.
         */
        var tags: List<Tag>? = null
        /**
         * The type of provisioned product. The supported values are `CFN_STACK` and `CFN_STACKSET`.
         */
        var type: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM user.
         */
        var userArn: kotlin.String? = null
        /**
         * The ARN of the IAM user in the session. This ARN might contain a session ID.
         */
        var userArnSession: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductAttribute) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.id = x.id
            this.idempotencyToken = x.idempotencyToken
            this.lastProvisioningRecordId = x.lastProvisioningRecordId
            this.lastRecordId = x.lastRecordId
            this.lastSuccessfulProvisioningRecordId = x.lastSuccessfulProvisioningRecordId
            this.name = x.name
            this.physicalId = x.physicalId
            this.productId = x.productId
            this.productName = x.productName
            this.provisioningArtifactId = x.provisioningArtifactId
            this.provisioningArtifactName = x.provisioningArtifactName
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
            this.type = x.type
            this.userArn = x.userArn
            this.userArnSession = x.userArnSession
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductAttribute = ProvisionedProductAttribute(this)
    }
}
