// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



/**
 * Information about a provisioning artifact (also known as a version) for a product.
 */
class ProvisioningArtifactProperties private constructor(builder: Builder) {
    /**
     * The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
     */
    val description: kotlin.String? = builder.description
    /**
     * If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.
     */
    val disableTemplateValidation: kotlin.Boolean = builder.disableTemplateValidation
    /**
     * Specify the template source with one of the following options, but not both. Keys accepted: &#91; `LoadTemplateFromURL`, `ImportFromPhysicalId` &#93;
     *
     * The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:
     *
     * `"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."`
     *
     * `ImportFromPhysicalId`: The physical id of the resource that contains the template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON format as follows: `ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]`
     */
    val info: Map<String, String>? = builder.info
    /**
     * The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
     */
    val name: kotlin.String? = builder.name
    /**
     * The type of provisioning artifact.
     * + `CLOUD_FORMATION_TEMPLATE` - AWS CloudFormation template
     * + `MARKETPLACE_AMI` - AWS Marketplace AMI
     * + `MARKETPLACE_CAR` - AWS Marketplace Clusters and AWS Resources
     */
    val type: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisioningArtifactProperties(")
        append("description=$description,")
        append("disableTemplateValidation=$disableTemplateValidation,")
        append("info=$info,")
        append("name=$name,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (disableTemplateValidation.hashCode())
        result = 31 * result + (info?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisioningArtifactProperties

        if (description != other.description) return false
        if (disableTemplateValidation != other.disableTemplateValidation) return false
        if (info != other.info) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
         */
        var description: kotlin.String? = null
        /**
         * If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.
         */
        var disableTemplateValidation: kotlin.Boolean = false
        /**
         * Specify the template source with one of the following options, but not both. Keys accepted: &#91; `LoadTemplateFromURL`, `ImportFromPhysicalId` &#93;
         *
         * The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:
         *
         * `"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."`
         *
         * `ImportFromPhysicalId`: The physical id of the resource that contains the template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON format as follows: `ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]`
         */
        var info: Map<String, String>? = null
        /**
         * The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
         */
        var name: kotlin.String? = null
        /**
         * The type of provisioning artifact.
         * + `CLOUD_FORMATION_TEMPLATE` - AWS CloudFormation template
         * + `MARKETPLACE_AMI` - AWS Marketplace AMI
         * + `MARKETPLACE_CAR` - AWS Marketplace Clusters and AWS Resources
         */
        var type: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties) : this() {
            this.description = x.description
            this.disableTemplateValidation = x.disableTemplateValidation
            this.info = x.info
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties = ProvisioningArtifactProperties(this)
    }
}
